/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.pssm.validation.constraints;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Reception;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;

public class PssmTransitionSignalEventReceptionsConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        Transition transition = (Transition)ctx.getTarget();
        StateMachine stateMachine = transition.containingStateMachine();
        BehavioredClassifier context = stateMachine.getContext();
        if (context == null) {
            context = stateMachine;
        }
        List receptionSignals = context.allFeatures().stream().filter(f -> f instanceof Reception).map(Reception.class::cast).map(r -> r.getSignal()).collect(Collectors.toList());
        List triggersSignals = transition.getTriggers().stream().map(t -> t.getEvent()).filter(e -> e instanceof SignalEvent).map(SignalEvent.class::cast).map(se -> se.getSignal()).collect(Collectors.toList());
        Boolean expression = receptionSignals.containsAll(triggersSignals);
        if (!expression.booleanValue()) {
            return ctx.createFailureStatus(new Object[]{"Transition - The Signals of any SignalEvents on the triggers of a Transition must have matching Receptions that are owned or  inherited by the context of the containing StateMachine of the Transition."});
        }
        return ctx.createSuccessStatus();
    }
}

