/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.pssm.validation.constraints;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.Type;

public class PssmStateBehaviorParametersConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        State state = (State)ctx.getTarget();
        ArrayList<State> allState = new ArrayList<State>();
        allState.add(state);
        if (state.getContainer() != null && state.getContainer().getState() != null) {
            allState.add(state.getContainer().getState());
        }
        HashSet allIncoming = new HashSet();
        allState.stream().forEach(s -> {
            boolean bl = allIncoming.addAll(s.getIncomings());
        });
        allState.stream().forEach(s -> s.getConnectionPoints().stream().filter(ps -> ps.getKind().equals((Object)PseudostateKind.ENTRY_POINT_LITERAL)).forEach(ep -> {
            boolean bl = allIncoming.addAll(ep.getIncomings());
        }));
        HashSet incomingInPseudostate = new HashSet();
        allIncoming.stream().forEach(t -> {
            boolean bl = incomingInPseudostate.addAll(t.getSource() instanceof Pseudostate ? ((Pseudostate)t.getSource()).getIncomings() : Collections.emptySet());
        });
        allIncoming.addAll(incomingInPseudostate);
        HashSet allOutgoing = new HashSet();
        allState.stream().forEach(s -> {
            boolean bl = allOutgoing.addAll(s.getOutgoings());
        });
        allState.stream().forEach(s -> s.getConnectionPoints().stream().filter(ps -> ps.getKind().equals((Object)PseudostateKind.EXIT_POINT_LITERAL)).forEach(ep -> {
            boolean bl = allOutgoing.addAll(ep.getIncomings());
        }));
        HashSet outgoingOfPseudostate = new HashSet();
        allOutgoing.stream().forEach(t -> {
            boolean bl = outgoingOfPseudostate.addAll(t.getTarget() instanceof Pseudostate ? ((Pseudostate)t.getTarget()).getOutgoings() : Collections.emptySet());
        });
        allOutgoing.addAll(outgoingOfPseudostate);
        Boolean expression = true;
        ArrayList<Trigger> allIncomingTriggers = new ArrayList<Trigger>();
        allIncoming.stream().forEach(t -> {
            boolean bl = allIncomingTriggers.addAll((Collection<Trigger>)t.getTriggers());
        });
        ArrayList<Trigger> allOutgoingTriggers = new ArrayList<Trigger>();
        allOutgoing.stream().forEach(t -> {
            boolean bl = allOutgoingTriggers.addAll((Collection<Trigger>)t.getTriggers());
        });
        if (state.getEntry() != null) {
            expression = expression & this.conformsToAll((List<Parameter>)state.getEntry().getOwnedParameters(), allIncomingTriggers);
        }
        if (expression.booleanValue() && state.getDoActivity() != null) {
            expression = expression & this.conformsToAll((List<Parameter>)state.getDoActivity().getOwnedParameters(), allIncomingTriggers);
        }
        if (expression.booleanValue() && state.getExit() != null) {
            expression = expression & this.conformsToAll((List<Parameter>)state.getExit().getOwnedParameters(), allOutgoingTriggers);
        }
        if (expression.booleanValue()) {
            List<List<Transition>> outgoingCompositionTransition = this.getAllOutgoingCompositeTransition(state);
            for (Transition transition : allOutgoing) {
                Behavior behavior;
                List<Trigger> compositeTransitionTriggers = this.getCompositeTransitionTriggers(transition, outgoingCompositionTransition);
                if (transition.getEffect() != null) {
                    expression = expression & this.conformsToAll((List<Parameter>)transition.getEffect().getOwnedParameters(), compositeTransitionTriggers);
                }
                if (transition.getGuard() == null || !(transition.getGuard().getSpecification() instanceof OpaqueExpression) || (behavior = ((OpaqueExpression)transition.getGuard().getSpecification()).getBehavior()) == null) continue;
                expression = expression & this.conformsToAll(behavior.getOwnedParameters().stream().filter(p -> !p.getDirection().equals((Object)ParameterDirectionKind.RETURN_LITERAL)).collect(Collectors.toList()), compositeTransitionTriggers);
            }
        }
        if (!expression.booleanValue()) {
            return ctx.createFailureStatus(new Object[]{"State - The entry and doActivity Behaviors of a State must conform to all the Triggers of Transitions that might cause the  State to be entered. The exit Behavior of a State must conform to all the Triggers of Transitions that might cause the  State to be exited. The effect and guard Behaviors of an outgoing Transition of a State must conform to all the  Triggers of the Transition. (Note that only Transitions outgoing from a State may have triggers.)"});
        }
        return ctx.createSuccessStatus();
    }

    /*
     * Unable to fully structure code
     */
    protected boolean conformsToAll(List<Parameter> signature, List<Trigger> triggers) {
        result = signature.isEmpty();
        v0 = parameter = signature.size() == 1 ? signature.get(0) : null;
        if (!triggers.stream().map((Function<Trigger, Event>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$13(org.eclipse.uml2.uml.Trigger ), (Lorg/eclipse/uml2/uml/Trigger;)Lorg/eclipse/uml2/uml/Event;)()).allMatch((Predicate<Event>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$14(org.eclipse.uml2.uml.Event ), (Lorg/eclipse/uml2/uml/Event;)Z)()) || parameter == null || !parameter.getDirection().equals((Object)ParameterDirectionKind.IN_LITERAL) || !parameter.is(1, 1)) ** GOTO lbl-1000
        if (parameter.getType() == null) ** GOTO lbl-1000
        if (triggers.stream().map((Function<Trigger, Event>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$15(org.eclipse.uml2.uml.Trigger ), (Lorg/eclipse/uml2/uml/Trigger;)Lorg/eclipse/uml2/uml/Event;)()).map((Function<Event, SignalEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, cast(java.lang.Object ), (Lorg/eclipse/uml2/uml/Event;)Lorg/eclipse/uml2/uml/SignalEvent;)(SignalEvent.class)).map((Function<SignalEvent, Signal>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$17(org.eclipse.uml2.uml.SignalEvent ), (Lorg/eclipse/uml2/uml/SignalEvent;)Lorg/eclipse/uml2/uml/Signal;)()).allMatch((Predicate<Signal>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$18(org.eclipse.uml2.uml.Parameter org.eclipse.uml2.uml.Signal ), (Lorg/eclipse/uml2/uml/Signal;)Z)((Parameter)parameter))) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        result |= v1;
        if (!triggers.stream().map((Function<Trigger, Event>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$19(org.eclipse.uml2.uml.Trigger ), (Lorg/eclipse/uml2/uml/Trigger;)Lorg/eclipse/uml2/uml/Event;)()).allMatch((Predicate<Event>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$20(org.eclipse.uml2.uml.Event ), (Lorg/eclipse/uml2/uml/Event;)Z)())) ** GOTO lbl-1000
        if (triggers.stream().map((Function<Trigger, Event>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$21(org.eclipse.uml2.uml.Trigger ), (Lorg/eclipse/uml2/uml/Trigger;)Lorg/eclipse/uml2/uml/Event;)()).map((Function<Event, CallEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, cast(java.lang.Object ), (Lorg/eclipse/uml2/uml/Event;)Lorg/eclipse/uml2/uml/CallEvent;)(CallEvent.class)).map((Function<CallEvent, Operation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$23(org.eclipse.uml2.uml.CallEvent ), (Lorg/eclipse/uml2/uml/CallEvent;)Lorg/eclipse/uml2/uml/Operation;)()).allMatch((Predicate<Operation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$24(java.util.List org.eclipse.uml2.uml.Operation ), (Lorg/eclipse/uml2/uml/Operation;)Z)((PssmStateBehaviorParametersConstraint)this, signature))) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        return result |= v2;
    }

    protected boolean conforms(List<Parameter> signature1, List<Parameter> signature2) {
        boolean result = true;
        if (signature1.size() == signature2.size()) {
            int i = 0;
            while (result && i < signature1.size()) {
                Parameter parameter1 = signature1.get(i);
                Parameter parameter2 = signature2.get(i);
                result &= parameter1.getDirection().equals((Object)parameter2.getDirection()) && parameter1.isOrdered() == parameter2.isOrdered() && parameter1.isUnique() == parameter2.isUnique();
                if (parameter2.getDirection().equals((Object)ParameterDirectionKind.IN_LITERAL)) {
                    result &= parameter2.getType() == null || parameter2.getType() != null && parameter2.getType().conformsTo(parameter1.getType()) && parameter2.compatibleWith((MultiplicityElement)parameter1);
                } else if (parameter2.getDirection().equals((Object)ParameterDirectionKind.RETURN_LITERAL) || parameter2.getDirection().equals((Object)ParameterDirectionKind.OUT_LITERAL)) {
                    result &= parameter1.getType() == null || parameter1.getType() != null && parameter1.getType().conformsTo(parameter2.getType()) && parameter1.compatibleWith((MultiplicityElement)parameter2);
                } else if (parameter2.getDirection().equals((Object)ParameterDirectionKind.INOUT_LITERAL)) {
                    result &= parameter1.getType().equals(parameter2.getType()) && parameter2.compatibleWith((MultiplicityElement)parameter1) && parameter1.compatibleWith((MultiplicityElement)parameter2);
                }
                ++i;
            }
            return result;
        }
        return false;
    }

    private List<List<Transition>> getAllOutgoingCompositeTransition(State state) {
        ArrayList<Transition> intermediateList;
        ArrayList<List<Transition>> compositions = new ArrayList<List<Transition>>();
        EList directOutgoingTransitions = state.getOutgoings();
        State parent = state.getContainer().getState();
        if (parent != null) {
            for (Transition transition : directOutgoingTransitions) {
                intermediateList = new ArrayList<Transition>();
                intermediateList.addAll((Collection<Transition>)parent.getOutgoings());
                intermediateList.add(transition);
                compositions.add(intermediateList);
            }
        }
        for (Transition transition : directOutgoingTransitions) {
            if (!(transition.getTarget() instanceof Pseudostate) || ((Pseudostate)transition.getTarget()).getKind() != PseudostateKind.ENTRY_POINT_LITERAL) continue;
            intermediateList = new ArrayList();
            intermediateList.add(transition);
            intermediateList.addAll((Collection<Transition>)transition.getTarget().getOutgoings());
            compositions.add(intermediateList);
        }
        return compositions;
    }

    private List<Trigger> getCompositeTransitionTriggers(Transition transition, List<List<Transition>> outgoingCompositionTransition) {
        ArrayList<Trigger> triggers = new ArrayList<Trigger>((Collection<Trigger>)transition.getTriggers());
        for (List<Transition> list : outgoingCompositionTransition) {
            if (!list.contains(transition)) continue;
            list.forEach(t -> {
                boolean bl = triggers.addAll((Collection<Trigger>)t.getTriggers());
            });
        }
        return triggers;
    }

    private static /* synthetic */ Event lambda$13(Trigger t) {
        return t.getEvent();
    }

    private static /* synthetic */ boolean lambda$14(Event e) {
        return e instanceof SignalEvent;
    }

    private static /* synthetic */ Event lambda$15(Trigger t) {
        return t.getEvent();
    }

    private static /* synthetic */ Signal lambda$17(SignalEvent se) {
        return se.getSignal();
    }

    private static /* synthetic */ boolean lambda$18(Parameter parameter, Signal s) {
        return parameter.getType().conformsTo((Type)s);
    }

    private static /* synthetic */ Event lambda$19(Trigger t) {
        return t.getEvent();
    }

    private static /* synthetic */ boolean lambda$20(Event e) {
        return e instanceof CallEvent;
    }

    private static /* synthetic */ Event lambda$21(Trigger t) {
        return t.getEvent();
    }

    private static /* synthetic */ Operation lambda$23(CallEvent ce) {
        return ce.getOperation();
    }

    private /* synthetic */ boolean lambda$24(List list, Operation o) {
        return this.conforms(list, (List<Parameter>)o.getOwnedParameters()) || this.conforms(list, o.getOwnedParameters().stream().filter(p -> p.getDirection().equals((Object)ParameterDirectionKind.IN_LITERAL)).collect(Collectors.toList()));
    }
}

