/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.kernel.process;

import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.moka.kernel.engine.EngineConfiguration;
import org.eclipse.papyrus.moka.kernel.engine.IExecutionEngine;
import org.eclipse.papyrus.moka.kernel.process.BaseProcess;
import org.eclipse.papyrus.moka.kernel.process.ExecutionEngineJob;
import org.eclipse.papyrus.moka.kernel.process.IExecutionEngineContainer;
import org.eclipse.papyrus.moka.kernel.process.MokaProcessStatus;

public class ExecutionEngineProcess
extends BaseProcess<ExecutionEngineJob>
implements IJobChangeListener,
IExecutionEngineContainer {
    public ExecutionEngineProcess(ILaunch launch, IExecutionEngine engine, EngineConfiguration<? extends EObject> config) {
        super(launch);
        this.process = new ExecutionEngineJob(engine, config);
        ((ExecutionEngineJob)this.process).addJobChangeListener(this);
    }

    public boolean canTerminate() {
        return this.getStatus().equals((Object)MokaProcessStatus.RUNNING);
    }

    public boolean isTerminated() {
        return this.getStatus().equals((Object)MokaProcessStatus.TERMINATED);
    }

    public void terminate() throws DebugException {
        ((ExecutionEngineJob)this.process).cancel();
    }

    public IStreamsProxy getStreamsProxy() {
        return null;
    }

    public int getExitValue() throws DebugException {
        if (!this.isTerminated()) {
            throw new DebugException(Status.CANCEL_STATUS);
        }
        return ((ExecutionEngineJob)this.process).getResult().getCode();
    }

    @Override
    public void run() {
        if (this.process != null) {
            ((ExecutionEngineJob)this.process).setPriority(20);
            ((ExecutionEngineJob)this.process).schedule();
        }
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    public void done(IJobChangeEvent event) {
        this.setStatus(MokaProcessStatus.TERMINATED);
        this.fireTerminateEvent();
    }

    public void running(IJobChangeEvent event) {
        this.setStatus(MokaProcessStatus.RUNNING);
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }

    @Override
    public IExecutionEngine getExecutionEngine() {
        if (this.process != null) {
            return ((ExecutionEngineJob)this.process).getExecutionEngine();
        }
        return null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    private void fireTerminateEvent() {
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this, 8)});
    }
}

