/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.activities;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.moka.fuml.actions.OutputPinActivation;
import org.eclipse.papyrus.moka.fuml.activities.ActivityNodeActivation;
import org.eclipse.papyrus.moka.fuml.activities.IActivityEdgeInstance;
import org.eclipse.papyrus.moka.fuml.activities.IObjectNodeActivation;
import org.eclipse.papyrus.moka.fuml.activities.IToken;
import org.eclipse.papyrus.moka.fuml.activities.ObjectToken;
import org.eclipse.papyrus.moka.fuml.profiling.activities.ObjectNodeActivationProfiler;
import org.eclipse.papyrus.moka.fuml.profiling.debug.NullTokenPropagationProfiler;

public abstract class ObjectNodeActivation
extends ActivityNodeActivation
implements IObjectNodeActivation {
    public Integer offeredTokenCount;

    @Override
    public void run() {
        super.run();
        this.offeredTokenCount = 0;
    }

    @Override
    public void sendOffers(List<IToken> tokens) {
        if (tokens.size() == 0) {
            ObjectToken token = new ObjectToken();
            token.holder = this;
            tokens.add(token);
        }
        super.sendOffers(tokens);
    }

    @Override
    public void terminate() {
        super.terminate();
        this.clearTokens();
    }

    @Override
    public void addToken(IToken token) {
        if (token.getValue() == null) {
            token.withdraw();
        } else {
            super.addToken(token);
        }
    }

    @Override
    public Integer removeToken(IToken token) {
        int i = super.removeToken(token);
        if (i > 0 & i <= this.offeredTokenCount) {
            this.offeredTokenCount = this.offeredTokenCount - 1;
        }
        return i;
    }

    @Override
    public void clearTokens() {
        super.clearTokens();
        this.offeredTokenCount = 0;
    }

    public Integer countOfferedValues() {
        int totalValueCount = 0;
        int i = 1;
        while (i <= this.incomingEdges.size()) {
            totalValueCount += ((IActivityEdgeInstance)this.incomingEdges.get(i - 1)).countOfferedValues().intValue();
            ++i;
        }
        return totalValueCount;
    }

    public void sendUnofferedTokens() {
        ObjectNodeActivation objectNodeActivation = this;
        List<IToken> list = objectNodeActivation.getUnofferedTokens();
        if (objectNodeActivation instanceof OutputPinActivation) {
            NullTokenPropagationProfiler.aspectOf().ajc$afterReturning$org_eclipse_papyrus_moka_fuml_profiling_debug_NullTokenPropagationProfiler$1$83831986((OutputPinActivation)objectNodeActivation, list);
        }
        List<IToken> tokens = list;
        this.offeredTokenCount = this.offeredTokenCount + tokens.size();
        List<IToken> list2 = tokens;
        ObjectNodeActivation objectNodeActivation2 = this;
        ObjectNodeActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_activities_ObjectNodeActivationProfiler$1$8827a211(objectNodeActivation2, list2);
        objectNodeActivation2.sendOffers(list2);
    }

    public Integer countUnofferedTokens() {
        if (this.heldTokens.size() == 0) {
            this.offeredTokenCount = 0;
        }
        return this.heldTokens.size() - this.offeredTokenCount;
    }

    public List<IToken> getUnofferedTokens() {
        ArrayList<IToken> tokens = new ArrayList<IToken>();
        int i = 1;
        while (i <= this.countUnofferedTokens()) {
            tokens.add((IToken)this.heldTokens.get(this.offeredTokenCount + i - 1));
            ++i;
        }
        return tokens;
    }

    public List<IToken> takeUnofferedTokens() {
        ObjectNodeActivation objectNodeActivation = this;
        List<IToken> list = objectNodeActivation.getUnofferedTokens();
        if (objectNodeActivation instanceof OutputPinActivation) {
            NullTokenPropagationProfiler.aspectOf().ajc$afterReturning$org_eclipse_papyrus_moka_fuml_profiling_debug_NullTokenPropagationProfiler$1$83831986((OutputPinActivation)objectNodeActivation, list);
        }
        List<IToken> tokens = list;
        int i = 0;
        while (i < tokens.size()) {
            IToken token = tokens.get(i);
            token.withdraw();
            ++i;
        }
        return tokens;
    }
}

