/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.moka.fuml.actions.IActionActivation;
import org.eclipse.papyrus.moka.fuml.actions.IPinActivation;
import org.eclipse.papyrus.moka.fuml.activities.IActivityEdgeInstance;
import org.eclipse.papyrus.moka.fuml.activities.IToken;
import org.eclipse.papyrus.moka.fuml.activities.ObjectNodeActivation;
import org.eclipse.papyrus.moka.fuml.debug.Debug;
import org.eclipse.papyrus.moka.fuml.profiling.activities.ActivityEdgeInstanceProfiler;
import org.eclipse.papyrus.moka.fuml.profiling.activities.PinActivationProfiler;
import org.eclipse.uml2.uml.Pin;

public abstract class PinActivation
extends ObjectNodeActivation
implements IPinActivation {
    public IActionActivation actionActivation;

    @Override
    public void fire(List<IToken> incomingTokens) {
        Debug.println("[fire] Pin " + (this.node == null ? "" : String.valueOf(this.node.getName()) + "..."));
        List<IToken> list = incomingTokens;
        PinActivation pinActivation = this;
        try {
            pinActivation.addTokens(list);
        }
        finally {
            PinActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_activities_PinActivationProfiler$1$44250678(pinActivation, list);
        }
    }

    @Override
    public List<IToken> takeOfferedTokens() {
        int count = this.countUnofferedTokens();
        int upper = -1;
        if (this.node != null) {
            upper = ((Pin)this.node).getUpper();
        }
        ArrayList<IToken> tokens = new ArrayList<IToken>();
        if (upper < 0 | count < upper) {
            List incomingEdges = this.incomingEdges;
            int i = 0;
            while (i < incomingEdges.size()) {
                IActivityEdgeInstance edge = (IActivityEdgeInstance)incomingEdges.get(i);
                int incomingCount = edge.countOfferedValues();
                List incomingTokens = new ArrayList();
                if (upper < 0 | incomingCount < upper - count) {
                    IActivityEdgeInstance iActivityEdgeInstance = edge;
                    List list = iActivityEdgeInstance.takeOfferedTokens();
                    ActivityEdgeInstanceProfiler.aspectOf().ajc$afterReturning$org_eclipse_papyrus_moka_fuml_profiling_activities_ActivityEdgeInstanceProfiler$2$2af4857d(iActivityEdgeInstance, list);
                    incomingTokens = list;
                    count += incomingCount;
                } else if (count < upper) {
                    Integer n = upper - count;
                    IActivityEdgeInstance iActivityEdgeInstance = edge;
                    List list = iActivityEdgeInstance.takeOfferedTokens(n);
                    ActivityEdgeInstanceProfiler.aspectOf().ajc$afterReturning$org_eclipse_papyrus_moka_fuml_profiling_activities_ActivityEdgeInstanceProfiler$3$21cb7f06(iActivityEdgeInstance, n, list);
                    incomingTokens = list;
                    count = upper;
                }
                int j = 0;
                while (j < incomingTokens.size()) {
                    IToken token = (IToken)incomingTokens.get(j);
                    tokens.add(token);
                    ++j;
                }
                ++i;
            }
        }
        return tokens;
    }

    public IActionActivation getActionActivation() {
        return this.actionActivation;
    }

    public void setActionActivation(IActionActivation actionActivation) {
        this.actionActivation = actionActivation;
    }
}

