/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.moka.fuml.actions.ICallActionActivation;
import org.eclipse.papyrus.moka.fuml.actions.InvocationActionActivation;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IExecution;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IParameterValue;
import org.eclipse.papyrus.moka.fuml.commonbehavior.ParameterValue;
import org.eclipse.papyrus.moka.fuml.profiling.activities.CallActionActivationProfiler;
import org.eclipse.papyrus.moka.fuml.profiling.activities.PinActivationProfiler;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IValue;
import org.eclipse.uml2.uml.CallAction;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;

public abstract class CallActionActivation
extends InvocationActionActivation
implements ICallActionActivation {
    public List<IExecution> callExecutions = new ArrayList<IExecution>();

    @Override
    public void doAction() {
        IExecution callExecution = this.getCallExecution();
        if (callExecution != null) {
            this.callExecutions.add(callExecution);
            CallAction callAction = (CallAction)this.node;
            EList argumentPins = callAction.getArguments();
            EList resultPins = callAction.getResults();
            EList parameters = callExecution.getBehavior().getOwnedParameters();
            int pinNumber = 1;
            int i = 1;
            while (i <= parameters.size()) {
                Parameter parameter = (Parameter)parameters.get(i - 1);
                if (parameter.getDirection() == ParameterDirectionKind.IN_LITERAL | parameter.getDirection() == ParameterDirectionKind.INOUT_LITERAL) {
                    List<IValue> list;
                    ParameterValue parameterValue = new ParameterValue();
                    parameterValue.parameter = parameter;
                    InputPin inputPin = (InputPin)argumentPins.get(pinNumber - 1);
                    CallActionActivation callActionActivation = this;
                    try {
                        list = callActionActivation.takeTokens(inputPin);
                    }
                    finally {
                        PinActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_activities_PinActivationProfiler$2$e210d285(callActionActivation, inputPin);
                    }
                    parameterValue.values = list;
                    callExecution.setParameterValue((IParameterValue)parameterValue);
                    ++pinNumber;
                }
                ++i;
            }
            callExecution.execute();
            List outputParameterValues = callExecution.getOutputParameterValues();
            pinNumber = 1;
            i = 1;
            while (i <= parameters.size()) {
                Parameter parameter = (Parameter)parameters.get(i - 1);
                if (parameter.getDirection() == ParameterDirectionKind.INOUT_LITERAL | parameter.getDirection() == ParameterDirectionKind.OUT_LITERAL | parameter.getDirection() == ParameterDirectionKind.RETURN_LITERAL) {
                    int j = 0;
                    while (j < outputParameterValues.size()) {
                        IParameterValue outputParameterValue = (IParameterValue)outputParameterValues.get(j);
                        if (outputParameterValue.getParameter() == parameter) {
                            OutputPin resultPin = (OutputPin)resultPins.get(pinNumber - 1);
                            this.putTokens(resultPin, outputParameterValue.getValues());
                        }
                        ++j;
                    }
                    ++pinNumber;
                }
                ++i;
            }
            callExecution.destroy();
            IExecution iExecution = callExecution;
            CallActionActivation callActionActivation = this;
            try {
                callActionActivation.removeCallExecution(iExecution);
            }
            finally {
                CallActionActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_activities_CallActionActivationProfiler$1$833119cd(callActionActivation, iExecution);
            }
        }
    }

    public abstract IExecution getCallExecution();

    @Override
    public void terminate() {
        int i = 0;
        while (i < this.callExecutions.size()) {
            IExecution execution = this.callExecutions.get(i);
            execution.terminate();
            ++i;
        }
        super.terminate();
    }

    public void removeCallExecution(IExecution execution) {
        boolean notFound = true;
        int i = 1;
        while (notFound & i <= this.callExecutions.size()) {
            if (this.callExecutions.get(i - 1) == execution) {
                this.callExecutions.remove(i - 1);
                notFound = false;
            }
            ++i;
        }
    }
}

