/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.standardlibrary.library.io;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IExecution;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IParameterValue;
import org.eclipse.papyrus.moka.fuml.debug.Debug;
import org.eclipse.papyrus.moka.fuml.library.ServiceObject;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.StringValue;
import org.eclipse.papyrus.moka.fuml.standardlibrary.library.io.FUMLIOConsole;
import org.eclipse.papyrus.moka.fuml.values.Value;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Operation;

public class StandardInputChannelImpl
extends ServiceObject {
    protected static BufferedReader bufferedReader;
    protected InputStream in = FUMLIOConsole.getInstance().getConsole().getInputStream();
    private static final String READLINE_OPERATION = "readLine";

    public StandardInputChannelImpl(Class service) {
        super(service);
    }

    public IExecution dispatch(Operation operation) {
        ReadLineExecution execution = null;
        if (operation != null && operation.getName().equals(READLINE_OPERATION)) {
            execution = new ReadLineExecution(operation);
        }
        return execution;
    }

    protected class ReadLineExecution
    extends ServiceObject.ServiceOperationExecution {
        public ReadLineExecution(Operation operation) {
            super((ServiceObject)StandardInputChannelImpl.this, operation);
        }

        public Value new_() {
            return new ReadLineExecution(this.operation);
        }

        public void doBody(List<IParameterValue> inputParameters, List<IParameterValue> outputParameters) {
            try {
                if (bufferedReader == null) {
                    bufferedReader = new BufferedReader(new InputStreamReader(StandardInputChannelImpl.this.in));
                }
                String line = bufferedReader.readLine();
                StringValue result = new StringValue();
                result.value = line;
                ArrayList<StringValue> outputs = new ArrayList<StringValue>();
                outputs.add(result);
                outputParameters.get(0).setValues(outputs);
            }
            catch (Exception e) {
                Debug.println((String)("An error occured during the execution of readLine " + e.getMessage()));
            }
        }
    }
}

