/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.engine.uml.time;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.papyrus.moka.engine.uml.time.actions.SendTimeEventOccurrence;
import org.eclipse.papyrus.moka.engine.uml.time.scheduling.de.DEScheduler;
import org.eclipse.papyrus.moka.engine.uml.time.scheduling.de.Event;
import org.eclipse.papyrus.moka.engine.uml.time.scheduling.de.actions.CallbackAction;
import org.eclipse.papyrus.moka.fuml.loci.ISemanticVisitor;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IEvaluation;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IRealValue;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IValue;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.IObject_;
import org.eclipse.papyrus.moka.pssm.values.ISM_OpaqueExpressionEvaluation;
import org.eclipse.uml2.uml.TimeEvent;
import org.eclipse.uml2.uml.Trigger;

public class UMLTimedExecutionEngineUtils {
    public static boolean isTimeTriggered(List<Trigger> triggers) {
        boolean timeTriggered = false;
        Iterator<Trigger> triggerIterator = triggers.iterator();
        while (!timeTriggered && triggerIterator.hasNext()) {
            timeTriggered = triggerIterator.next().getEvent() instanceof TimeEvent;
        }
        return timeTriggered;
    }

    public static void pushEvents(List<Trigger> triggers, ISemanticVisitor visitor, IObject_ context) {
        for (Trigger trigger : triggers) {
            UMLTimedExecutionEngineUtils.pushEvent(trigger, visitor, context);
        }
    }

    private static void pushEvent(Trigger trigger, ISemanticVisitor visitor, IObject_ context) {
        IEvaluation evaluation;
        TimeEvent timeEvent;
        if (context != null && trigger != null && trigger.getEvent() instanceof TimeEvent && (timeEvent = (TimeEvent)trigger.getEvent()).getWhen() != null && timeEvent.getWhen().getExpr() != null && (evaluation = context.getLocus().getFactory().createEvaluation(timeEvent.getWhen().getExpr())) != null) {
            IValue value;
            if (evaluation instanceof ISM_OpaqueExpressionEvaluation) {
                ((ISM_OpaqueExpressionEvaluation)evaluation).setContext(context);
            }
            if ((value = evaluation.evaluate()) != null && value instanceof IRealValue) {
                double clockTime = DEScheduler.getInstance().getCurrentTime();
                Event clockEvent = new Event(((IRealValue)value).getValue().doubleValue(), (CallbackAction)new SendTimeEventOccurrence(clockTime, visitor, context));
                if (timeEvent.isRelative()) {
                    DEScheduler.getInstance().pushEvent(clockEvent);
                } else {
                    DEScheduler.getInstance().pushEvent(clockEvent, ((IRealValue)value).getValue().doubleValue());
                }
            }
        }
    }

    public static void cancelEvents(ISemanticVisitor visitor) {
        ArrayList<Event> toRemoveEvents = new ArrayList<Event>();
        List schedulerEvents = DEScheduler.getInstance().getEvents();
        for (Event event : schedulerEvents) {
            if (!(event.getAction() instanceof SendTimeEventOccurrence) || ((SendTimeEventOccurrence)event.getAction()).getVisitor() != visitor) continue;
            toRemoveEvents.add(event);
        }
        DEScheduler.getInstance().removeAllEvents(toRemoveEvents);
    }
}

