/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.properties.extension;

import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.gmfdiag.properties.Activator;
import org.eclipse.papyrus.infra.gmfdiag.properties.modelelement.StyleHandlerProvider;

public class StyleHandlerManager {
    public static final String EXTENSION_ID = "org.eclipse.papyrus.infra.gmfdiag.properties.stylehandler";
    private final List<StyleHandlerProvider> providers;
    public static StyleHandlerManager instance = new StyleHandlerManager();

    private StyleHandlerManager() {
        IConfigurationElement[] config;
        TreeMap<Integer, StyleHandlerProvider> providersMap = new TreeMap<Integer, StyleHandlerProvider>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                StyleHandlerProvider provider = (StyleHandlerProvider)e.createExecutableExtension("provider");
                String priorityString = e.getAttribute("priority");
                int priority = Integer.parseInt(priorityString);
                providersMap.put(priority, provider);
            }
            catch (NumberFormatException ex) {
                Activator.log.error("The plugin " + String.valueOf(e.getContributor()) + " provided an invalid extension for org.eclipse.papyrus.infra.gmfdiag.properties.stylehandler", (Throwable)ex);
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
            }
            ++n2;
        }
        this.providers = new LinkedList(providersMap.values());
    }

    public List<StyleHandlerProvider> getStyleHandlerProviders() {
        return this.providers;
    }
}

