/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils;

import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.papyrus.junit.utils.Activator;
import org.junit.runner.Description;

public class JUnitUtils {
    private JUnitUtils() {
    }

    public static Class<?> getTestClass(Description description) {
        Class<?> result = description.getTestClass();
        if (result == null) {
            for (Description child : description.getChildren()) {
                result = JUnitUtils.getTestClass(child);
                if (result != null) break;
            }
        }
        return result;
    }

    public static Iterable<Annotation> getAnnotations(Description description) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Annotation next : description.getAnnotations()) {
            result.put(next.annotationType(), next);
        }
        if (description.getTestClass() != null) {
            Annotation[] annotationArray = description.getTestClass().getAnnotations();
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation next;
                next = annotationArray[n2];
                if (!result.containsKey(next.annotationType())) {
                    result.put(next.annotationType(), next);
                }
                ++n2;
            }
        }
        return result.values();
    }

    public static <A extends Annotation> A getAnnotation(Description description, Class<A> type) {
        Annotation result = description.getAnnotation(type);
        if (result == null && description.getTestClass() != null) {
            result = description.getTestClass().getAnnotation(type);
        }
        return (A)result;
    }

    public static <A extends Annotation> List<A> getAnnotationsByType(Description description, Class<A> type) {
        if (!type.isAnnotationPresent(Repeatable.class)) {
            throw new IllegalArgumentException("not a repeatable annotation: @" + type.getName());
        }
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        Class<? extends Annotation> containerType = type.getAnnotation(Repeatable.class).value();
        Annotation container = description.getAnnotation(containerType);
        if (container != null) {
            try {
                Method method = JUnitUtils.findAnnotationContainerValue(containerType, type);
                Annotation[] annotations = (Annotation[])method.invoke((Object)container, new Object[0]);
                result.addAll(Arrays.asList(annotations));
            }
            catch (Exception method) {}
        } else {
            Annotation annotation = description.getAnnotation(type);
            if (annotation != null) {
                result.add(annotation);
            }
        }
        if (description.getTestClass() != null) {
            result.addAll(Arrays.asList(description.getTestClass().getAnnotationsByType(type)));
        }
        return result;
    }

    private static Method findAnnotationContainerValue(Class<? extends Annotation> containerType, Class<? extends Annotation> repeatableAnnotationType) {
        Method result = null;
        Method[] methodArray = containerType.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method next = methodArray[n2];
            if (next.getParameterCount() == 0 && next.getReturnType().isArray() && next.getReturnType().getComponentType() == repeatableAnnotationType) {
                result = next;
                break;
            }
            ++n2;
        }
        return result;
    }

    @SafeVarargs
    public static Annotation getAnyAnnotation(Description description, Class<? extends Annotation> ... types) {
        Annotation result = null;
        Class<? extends Annotation>[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Annotation> next = classArray[n2];
            result = description.getAnnotation(next);
            if (result != null) break;
            ++n2;
        }
        if (result == null) {
            Class testClass = description.getTestClass();
            block1: while (testClass != null) {
                Class<? extends Annotation>[] classArray2 = types;
                int n3 = types.length;
                n = 0;
                while (n < n3) {
                    Class<? extends Annotation> next = classArray2[n];
                    result = testClass.getAnnotation(next);
                    if (result != null) break block1;
                    ++n;
                }
                testClass = testClass.getSuperclass();
            }
        }
        return result;
    }

    public static boolean isAutomatedBuildExecution() {
        return Activator.getDefault().getRunningApplicationID().startsWith("org.eclipse.tycho.");
    }
}

