/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.newchild.internal.checkers;

import com.google.common.collect.ListMultimap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.infra.newchild.elementcreationmenumodel.Menu;
import org.eclipse.papyrus.toolsmiths.plugin.builder.AbstractPapyrusBuilder;
import org.eclipse.papyrus.toolsmiths.plugin.builder.IPapyrusBuilderProvider;
import org.eclipse.papyrus.toolsmiths.plugin.builder.PapyrusBuilderKind;
import org.eclipse.papyrus.toolsmiths.plugin.builder.PluginCheckerBuilder;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.ModelResourceMapper;
import org.eclipse.papyrus.toolsmiths.validation.newchild.internal.checkers.NewChildMenuPluginChecker;
import org.osgi.service.component.annotations.Component;

@Component
public class NewChildMenuBuilderProvider
implements IPapyrusBuilderProvider {
    public String getProblemMarkerType(PapyrusBuilderKind builderKind) {
        return "org.eclipse.papyrus.toolsmiths.validation.newchild.diagnostic";
    }

    public boolean providesBuilder(PapyrusBuilderKind builderKind, URI resourceURI) {
        return "creationmenumodel".equals(resourceURI.fileExtension());
    }

    public AbstractPapyrusBuilder getBuilder(PapyrusBuilderKind builderKind, IProject project) {
        PluginCheckerBuilder result = new PluginCheckerBuilder("org.eclipse.papyrus.toolsmiths.validation.newchild.diagnostic", this::mapNewChildResources);
        switch (builderKind) {
            case MODEL_RESOURCE: {
                result = result.withChecker(NewChildMenuPluginChecker.modelValidationCheckerFactory()).withChecker(NewChildMenuPluginChecker.customModelCheckerFactory());
                break;
            }
            case BUNDLE_MANIFEST: {
                result = result.withChecker(NewChildMenuPluginChecker.buildPropertiesCheckerFactory()).withChecker(NewChildMenuPluginChecker.modelDependenciesCheckerFactory());
                break;
            }
            case PLUGIN_MANIFEST: {
                result = result.withChecker(NewChildMenuPluginChecker.extensionsCheckerFactory());
            }
        }
        return result;
    }

    private ListMultimap<IFile, Menu> mapNewChildResources(IProject project) {
        ModelResourceMapper mapper = new ModelResourceMapper((IContainer)project);
        return mapper.map(ModelResourceMapper.byExtension((String)"creationmenumodel"), ModelResourceMapper.resourceSets(), ModelResourceMapper.rootsOfType(Menu.class));
    }
}

