/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.textedit.ui.internal.viewpoint;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.architecture.representation.PapyrusRepresentationKind;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.textedit.representation.TextDocumentRepresentation;
import org.eclipse.papyrus.infra.textedit.representation.command.ICreateTextDocumentEditorCommand;
import org.eclipse.papyrus.infra.textedit.textdocument.TextDocument;
import org.eclipse.papyrus.infra.textedit.textdocument.TextDocumentPackage;
import org.eclipse.papyrus.infra.textedit.ui.internal.viewpoint.ExtendedViewPrototype;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class TextDocumentViewPrototype
extends ViewPrototype
implements ExtendedViewPrototype<TextDocument> {
    private final ICreateTextDocumentEditorCommand command;

    public TextDocumentViewPrototype(TextDocumentRepresentation prototype, ICreateTextDocumentEditorCommand command) {
        super((PapyrusRepresentationKind)prototype);
        this.command = command;
    }

    public boolean isOwnerReassignable() {
        return true;
    }

    public boolean instantiateOn(EObject owner, String name, boolean openCreatedView) {
        return this.instantiateOn(owner, owner, name, openCreatedView) != null;
    }

    public boolean instantiateOn(EObject owner) {
        return this.instantiateOn(owner, null);
    }

    public boolean instantiateOn(EObject owner, String name) {
        return this.instantiateOn(owner, name, true);
    }

    public Command getCommandChangeOwner(EObject view, EObject target) {
        if (view instanceof TextDocument) {
            SetRequest request = new SetRequest(view, (EStructuralFeature)TextDocumentPackage.eINSTANCE.getTextDocument_GraphicalContext(), (Object)target);
            IElementEditService documentProvider = ElementEditServiceUtils.getCommandProvider((EObject)view);
            if (documentProvider != null) {
                return GMFtoEMFCommandWrapper.wrap((ICommand)documentProvider.getEditCommand((IEditCommandRequest)request));
            }
        }
        return null;
    }

    public Command getCommandChangeRoot(EObject view, EObject target) {
        if (view instanceof TextDocument) {
            SetRequest request = new SetRequest(view, (EStructuralFeature)TextDocumentPackage.eINSTANCE.getTextDocument_SemanticContext(), (Object)target);
            IElementEditService documentProvider = ElementEditServiceUtils.getCommandProvider((EObject)view);
            if (documentProvider != null) {
                return GMFtoEMFCommandWrapper.wrap((ICommand)documentProvider.getEditCommand((IEditCommandRequest)request));
            }
        }
        return null;
    }

    public EObject getOwnerOf(EObject view) {
        return ((TextDocument)view).getGraphicalContext();
    }

    public EObject getRootOf(EObject view) {
        return ((TextDocument)view).getSemanticContext();
    }

    @Override
    public TextDocument instantiateOn(EObject semanticOwner, EObject graphicalOwner, String name, boolean openCreatedView) {
        return this.command.execute((ViewPrototype)this, name, semanticOwner, graphicalOwner, openCreatedView);
    }
}

