/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.aggregator.p2view.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.cbi.p2repo.aggregator.Aggregation;
import org.eclipse.cbi.p2repo.aggregator.AggregatorFactory;
import org.eclipse.cbi.p2repo.aggregator.ChildrenProvider;
import org.eclipse.cbi.p2repo.aggregator.MetadataRepositoryReference;
import org.eclipse.cbi.p2repo.aggregator.Status;
import org.eclipse.cbi.p2repo.aggregator.StatusCode;
import org.eclipse.cbi.p2repo.aggregator.p2.util.MetadataRepositoryResourceImpl;
import org.eclipse.cbi.p2repo.aggregator.p2view.MetadataRepositoryStructuredView;
import org.eclipse.cbi.p2repo.aggregator.p2view.P2viewPackage;
import org.eclipse.cbi.p2repo.aggregator.p2view.RepositoryBrowser;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;

public class RepositoryBrowserImpl
extends MinimalEObjectImpl.Container
implements RepositoryBrowser {
    protected int eFlags = 0;
    protected static final boolean LOADING_EDEFAULT = false;
    private final NotifyDispatcher notifyDispatcher = new NotifyDispatcher();
    private final ResourceSet resourceSet;
    private Aggregation aggregation;

    protected RepositoryBrowserImpl() {
        throw new UnsupportedOperationException();
    }

    protected RepositoryBrowserImpl(Aggregation aggregation) {
        this.aggregation = aggregation;
        this.resourceSet = ((EObject)aggregation).eResource().getResourceSet();
        this.resourceSet.eAdapters().add((Object)this.notifyDispatcher);
    }

    public Aggregation getAggregation() {
        if (((EObject)this.aggregation).eIsProxy()) {
            this.aggregation = (Aggregation)this.resourceSet.getEObject(((InternalEObject)this.aggregation).eProxyURI(), true);
        }
        return this.aggregation;
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == ChildrenProvider.class) {
            switch (derivedFeatureID) {
                case 1: {
                    return 0;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == ChildrenProvider.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 1;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getStatus();
            }
            case 1: {
                return this.getChildren();
            }
            case 2: {
                return this.getRepositories();
            }
            case 3: {
                return this.isLoading();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.getStatus() != null;
            }
            case 1: {
                return !this.getChildren().isEmpty();
            }
            case 2: {
                return !this.getRepositories().isEmpty();
            }
            case 3: {
                return this.isSetLoading();
            }
        }
        return super.eIsSet(featureID);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.getRepositories().clear();
                this.getRepositories().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    protected EClass eStaticClass() {
        return P2viewPackage.Literals.REPOSITORY_BROWSER;
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.getRepositories().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public EList<MetadataRepositoryStructuredView> getChildren() {
        return this.getRepositories();
    }

    @Override
    public EList<MetadataRepositoryStructuredView> getRepositories() {
        List<Resource> resources = this.getResources();
        BasicEList result = new BasicEList(resources.size());
        for (Resource resource : resources) {
            EObject view;
            EList contents;
            if (!(resource instanceof MetadataRepositoryResourceImpl) || (contents = resource.getContents()).size() != 1 || !((view = (EObject)contents.get(0)) instanceof MetadataRepositoryStructuredView)) continue;
            result.add((Object)((MetadataRepositoryStructuredView)view));
        }
        return result;
    }

    private List<Resource> getResources() {
        ResourceSet rs;
        List<Resource> result = null;
        Resource aggrResource = ((EObject)this.getAggregation()).eResource();
        if (aggrResource != null && (rs = aggrResource.getResourceSet()) != null) {
            result = new ArrayList<Resource>((Collection<Resource>)rs.getResources());
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    @Override
    public Status getStatus() {
        Status result = null;
        for (Resource resource : this.getResources()) {
            if (!(resource instanceof MetadataRepositoryResourceImpl)) continue;
            Status childStatus = ((MetadataRepositoryResourceImpl)resource).getStatus();
            switch (childStatus.getCode()) {
                case BROKEN: {
                    return childStatus;
                }
                case WAITING: {
                    result = childStatus;
                }
            }
        }
        if (result == null) {
            result = AggregatorFactory.eINSTANCE.createStatus(StatusCode.OK);
        }
        return result;
    }

    @Override
    public boolean isLoading() {
        boolean loading = false;
        for (Resource resource : this.getResources()) {
            if (!(resource instanceof MetadataRepositoryResourceImpl) || !((MetadataRepositoryResourceImpl)resource).isLoading()) continue;
            loading = true;
            break;
        }
        return loading;
    }

    @Override
    public boolean isSetLoading() {
        return true;
    }

    class NotifyDispatcher
    extends EContentAdapter {
        NotifyDispatcher() {
        }

        public void notifyChanged(Notification notification) {
            boolean loading;
            Object nf = notification.getNotifier();
            boolean bl = loading = nf instanceof ResourceSet && notification.getFeatureID(ResourceSet.class) == 0;
            if (!loading) {
                boolean bl2 = loading = nf instanceof MetadataRepositoryReference && notification.getFeatureID(MetadataRepositoryReference.class) == 6;
            }
            if (loading) {
                RepositoryBrowserImpl.this.eNotify((Notification)new ENotificationImpl((InternalEObject)RepositoryBrowserImpl.this, 1, 3, null, null));
            }
        }
    }
}

