/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.m2m.qvto.tests.tools.tests;

import com.google.common.cache.LoadingCache;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.utils.EqualityHelper;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateParameterSubstitution;

public class UMLIgnoringIdentifiedEqualityHelper
extends EqualityHelper {
    public UMLIgnoringIdentifiedEqualityHelper(LoadingCache<EObject, URI> uriCache) {
        super(uriCache);
    }

    protected boolean matchingEObjects(EObject object1, EObject object2) {
        EClass eClass1 = object1.eClass();
        EClass eClass2 = object2.eClass();
        boolean result = false;
        if (eClass1 == eClass2) {
            result = object1.eIsProxy() && object2.eIsProxy() ? super.matchingEObjects(object1, object2) : (object1 instanceof NamedElement && object2 instanceof NamedElement ? this.matchingNamedElement((NamedElement)object1, (NamedElement)object2) : (object1 instanceof Element && object2 instanceof Element ? this.matchingElement((Element)object1, (Element)object2) : (EcorePackage.eINSTANCE == object1.eClass().getEPackage() ? super.matchingEObjects(object1, object2) : super.matchingEObjects(object1, object2))));
        }
        return result;
    }

    protected boolean matchingNamedElement(NamedElement object1, NamedElement object2) {
        boolean result = false;
        String qn1 = object1.getQualifiedName();
        String qn2 = object2.getQualifiedName();
        if (qn1 == null && qn2 == null) {
            result = this.matchingValues(object1.eContainer(), object2.eContainer());
        }
        if (qn1 != null && qn2 != null) {
            result = qn1.equals(qn2);
        }
        return result;
    }

    protected boolean matchingElement(Element object1, Element object2) {
        EObject parent2;
        boolean result = false;
        EObject parent1 = object1.eContainer();
        if (this.matchingValues(parent1, parent2 = object2.eContainer())) {
            if (object1 instanceof PackageImport && object2 instanceof PackageImport) {
                Package importedPackage1 = ((PackageImport)object1).getImportedPackage();
                Package importedPackage2 = ((PackageImport)object2).getImportedPackage();
                result = importedPackage1.getQualifiedName().equals(importedPackage2.getQualifiedName());
            } else if (object1 instanceof ProfileApplication && object2 instanceof ProfileApplication) {
                ProfileApplication prof1 = (ProfileApplication)object1;
                ProfileApplication prof2 = (ProfileApplication)object2;
                Profile p1 = prof1.getAppliedProfile();
                Profile p2 = prof2.getAppliedProfile();
                String p1Qname = p1.getQualifiedName();
                String p2Qname = p2.getQualifiedName();
                if (p1Qname != null) {
                    result = p1Qname.equals(p2Qname);
                }
            } else if (object1 instanceof ConnectorEnd && object2 instanceof ConnectorEnd) {
                ConnectableElement role2;
                ConnectorEnd conn1 = (ConnectorEnd)object1;
                ConnectorEnd conn2 = (ConnectorEnd)object2;
                ConnectableElement role1 = conn1.getRole();
                boolean roleMatching = this.matchingValues(role1, role2 = conn2.getRole());
                if (roleMatching) {
                    Property partWithPort1 = conn1.getPartWithPort();
                    Property partWithPort2 = conn2.getPartWithPort();
                    result = this.matchingValues(partWithPort1, partWithPort2);
                }
            } else if (object1 instanceof Comment && object2 instanceof Comment) {
                String body1 = ((Comment)object1).getBody();
                String body2 = ((Comment)object2).getBody();
                if (body1 != null) {
                    result = body1.equals(body2);
                }
            } else if (object1 instanceof TemplateBinding && object2 instanceof TemplateBinding) {
                result = true;
            } else if (object1 instanceof TemplateParameterSubstitution && object2 instanceof TemplateParameterSubstitution) {
                result = true;
            }
        }
        return result;
    }
}

