/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.validate;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.gmf.internal.validate.IDefElementProvider;
import org.eclipse.papyrus.gmf.internal.validate.Messages;

class ValueSpecDef {
    private final IDefElementProvider.StringValProvider body;
    private final IDefElementProvider.StringValProvider lang;
    private final IDefElementProvider.TypeProvider type;

    public ValueSpecDef(IDefElementProvider.StringValProvider body, IDefElementProvider.StringValProvider lang) {
        this(body, lang, null);
    }

    public ValueSpecDef(IDefElementProvider.StringValProvider body, IDefElementProvider.StringValProvider lang, IDefElementProvider.TypeProvider typeRestriction) {
        if (body == null) {
            throw new IllegalArgumentException();
        }
        this.body = body;
        this.lang = lang;
        this.type = typeRestriction;
    }

    public boolean isOK() {
        return !(!this.body.getStatus().isOK() || this.lang != null && !this.lang.getStatus().isOK() || this.type != null && !this.type.getStatus().isOK());
    }

    public IDefElementProvider.TypeProvider getTypeRestriction() {
        return this.type;
    }

    public String createBody(EObject contextInstance) {
        return this.body.getValue(contextInstance);
    }

    public String createLanguage(EObject contextInstance) {
        if (this.lang == null) {
            return "ocl";
        }
        return this.lang.getValue(contextInstance);
    }

    public IDefElementProvider.StringValProvider getBody() {
        return this.body;
    }

    public IDefElementProvider.StringValProvider getLang() {
        return this.lang;
    }

    public String getLabel() {
        return Messages.def_ValueSpecDefLabel;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("body: ").append(this.body);
        buf.append(" lang: ").append(this.lang);
        return buf.toString();
    }
}

