/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dev.types.view;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.NullElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.papyrus.dev.types.Activator;
import org.eclipse.papyrus.dev.types.providers.TypesEventContentProvider;
import org.eclipse.papyrus.dev.types.providers.TypesEventLabelProvider;
import org.eclipse.papyrus.dev.types.utils.ElementTypeRegistryUtils;
import org.eclipse.papyrus.dev.types.utils.NotifierNullEditHelper;
import org.eclipse.papyrus.dev.types.utils.TypesEventPrinter;
import org.eclipse.papyrus.infra.types.core.notification.ITypesEventsChainListener;
import org.eclipse.papyrus.infra.types.core.notification.TypesEventsChain;
import org.eclipse.papyrus.infra.types.core.notification.TypesListenersRegistry;
import org.eclipse.papyrus.infra.types.core.notification.events.ITypesEvent;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.ViewPart;

public class TypesConfigurationsListenerView
extends ViewPart {
    IClientContext context = null;
    FilteredTree tree = null;
    SashForm sash = null;
    Browser browser = null;
    ITypesEventsChainListener listener = null;
    Text limitText = null;
    List<TypesEventsChain> eventsChains = new ArrayList<TypesEventsChain>();
    private final int MAX_SIZE = 1000;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(3, true));
        Button startButton = new Button(parent, 0);
        startButton.setText("Start");
        startButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (!Platform.inDebugMode()) {
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Debug mode", (String)"You must activate debug mode to be able to use this view. ");
                }
                if (Platform.inDebugMode()) {
                    Field nullElementTypeEditHelperField = ElementTypeRegistryUtils.getNullElementTypeEditHelper();
                    if (nullElementTypeEditHelperField != null) {
                        try {
                            nullElementTypeEditHelperField.set(NullElementType.getInstance(), (Object)new NotifierNullEditHelper());
                        }
                        catch (IllegalArgumentException e1) {
                            e1.printStackTrace();
                        }
                        catch (IllegalAccessException e1) {
                            e1.printStackTrace();
                        }
                    } else {
                        Activator.log.warn("Failed to override NullElementType's EditHelper");
                    }
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Debug mode", (String)"Be careful, as the platform is in debug mode, the NullElementType's EditHelper has been overriden");
                }
                if (TypesConfigurationsListenerView.this.listener == null) {
                    TypesConfigurationsListenerView.this.listener = new ITypesEventsChainListener(){

                        public void notifyChain(TypesEventsChain chain) {
                            int limit;
                            String text = (this).TypesConfigurationsListenerView.this.limitText.getText();
                            try {
                                limit = Integer.parseInt(text);
                            }
                            catch (NumberFormatException e) {
                                limit = 1000;
                            }
                            if ((this).TypesConfigurationsListenerView.this.eventsChains.size() >= limit) {
                                (this).TypesConfigurationsListenerView.this.eventsChains.remove(0);
                            }
                            (this).TypesConfigurationsListenerView.this.eventsChains.add(chain);
                            Display.getCurrent().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ((this).this).TypesConfigurationsListenerView.this.tree.getViewer().refresh();
                                }
                            });
                        }
                    };
                    TypesListenersRegistry.getInstance().addEventChainListener(TypesConfigurationsListenerView.this.listener);
                }
            }
        });
        startButton.setLayoutData((Object)new GridData(4, 4, true, false));
        Button stopButton = new Button(parent, 0);
        stopButton.setText("Stop");
        stopButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TypesListenersRegistry.getInstance().removeEventChainListener(TypesConfigurationsListenerView.this.listener);
                TypesConfigurationsListenerView.this.listener = null;
            }
        });
        stopButton.setLayoutData((Object)new GridData(4, 4, true, false));
        Button clearButton = new Button(parent, 0);
        clearButton.setText("Clear");
        clearButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TypesConfigurationsListenerView.this.eventsChains.clear();
                TypesConfigurationsListenerView.this.tree.getViewer().refresh();
                TypesConfigurationsListenerView.this.browser.setText("");
            }
        });
        clearButton.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = new Label(parent, 0);
        label.setText("Limit: ");
        this.limitText = new Text(parent, 2048);
        this.limitText.setText("1000");
        this.limitText.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.sash = new SashForm(parent, 2304);
        this.sash.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.tree = new FilteredTree((Composite)this.sash, 2048, new PatternFilter(), true);
        this.tree.getViewer().setLabelProvider((IBaseLabelProvider)new TypesEventLabelProvider());
        this.tree.getViewer().setContentProvider((IContentProvider)new TypesEventContentProvider());
        this.tree.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    Object first = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    String result = "";
                    if (first instanceof ITypesEvent) {
                        Map<String, String> details = TypesEventPrinter.getEventDetails((ITypesEvent)first);
                        result = TypesEventPrinter.printHtmlEvent(details);
                    } else if (first instanceof TypesEventsChain) {
                        IEditCommandRequest req = ((TypesEventsChain)first).getRequest();
                        result = TypesEventPrinter.printHtmRequest(req);
                    }
                    TypesConfigurationsListenerView.this.browser.setText(result);
                }
            }
        });
        this.tree.getViewer().setInput(this.eventsChains);
        this.browser = new Browser((Composite)this.sash, 0);
        this.sash.setWeights(new int[]{1, 3});
    }

    public void setFocus() {
    }

    public void dispose() {
        TypesListenersRegistry.getInstance().removeEventChainListener(this.listener);
        super.dispose();
    }
}

