/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.service;

import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.services.controlmode.listener.UncontrolModeSaveListener;
import org.eclipse.papyrus.infra.services.controlmode.service.IUncontrolledObjectsProvider;
import org.eclipse.papyrus.infra.ui.lifecycleevents.ILifeCycleEventsProvider;
import org.eclipse.papyrus.infra.ui.lifecycleevents.ISaveEventListener;

public class ControlModeService
implements IService {
    private ILifeCycleEventsProvider lifeCycleEventsProvider = null;
    private ISaveEventListener saveListener = null;
    private IUncontrolledObjectsProvider uncontrolledObjectsProvider = null;

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.lifeCycleEventsProvider = (ILifeCycleEventsProvider)ServiceUtils.getInstance().getService(ILifeCycleEventsProvider.class, (Object)servicesRegistry);
        this.uncontrolledObjectsProvider = (IUncontrolledObjectsProvider)ServiceUtils.getInstance().getService(IUncontrolledObjectsProvider.class, (Object)servicesRegistry);
    }

    public void startService() throws ServiceException {
        this.saveListener = new UncontrolModeSaveListener(this.uncontrolledObjectsProvider);
        this.lifeCycleEventsProvider.addDoSaveListener(this.saveListener);
    }

    public void disposeService() throws ServiceException {
        this.lifeCycleEventsProvider.removeDoSaveListener(this.saveListener);
        this.saveListener = null;
        this.lifeCycleEventsProvider = null;
        this.uncontrolledObjectsProvider = null;
    }
}

