/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.internationalization.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.internationalization.InternationalizationEntry;
import org.eclipse.papyrus.infra.internationalization.utils.InternationalizationKeyResolver;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLQualifiedNameUtils;
import org.eclipse.papyrus.uml.tools.utils.NameResolutionUtils;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Stereotype;

public class UMLInternationalizationKeyResolver
extends InternationalizationKeyResolver {
    private static final String QUALIFIED_NAME_SEPARATOR_REPLACEMENT = "__";
    private Map<String, NamedElement> elementsForQN = new HashMap<String, NamedElement>();

    public InternationalizationEntry createInternationalizationEntryByKey(String key, ResourceSet resourceSet, URI uri) {
        InternationalizationEntry entry = super.createInternationalizationEntryByKey(key, resourceSet, uri);
        Object entryKey = entry.getKey();
        if (entryKey instanceof String) {
            NamedElement namedElement;
            Resource umlResource;
            if (((String)entryKey).startsWith("_label_")) {
                entryKey = ((String)entryKey).substring("_label_".length());
            }
            String qualifiedName = ((String)entryKey).replaceAll(QUALIFIED_NAME_SEPARATOR_REPLACEMENT, "::");
            if (this.elementsForQN.isEmpty() && (umlResource = resourceSet.getResource(uri.trimFileExtension().appendFileExtension("uml"), true)) != null && umlResource.getContents() != null && !umlResource.getContents().isEmpty()) {
                this.computeElementsNames(umlResource);
            }
            if ((namedElement = this.elementsForQN.get(qualifiedName)) != null) {
                entry.setKey((Object)namedElement);
            }
        }
        return entry;
    }

    private void computeElementsNames(Resource resource) {
        TreeIterator contents = EcoreUtil.getAllProperContents((Resource)resource, (boolean)false);
        while (contents.hasNext()) {
            EObject eObject = (EObject)contents.next();
            if (!(eObject instanceof NamedElement)) continue;
            this.elementsForQN.put(((NamedElement)eObject).getQualifiedName(), (NamedElement)eObject);
        }
    }

    public String getKey(InternationalizationEntry entry) {
        StringBuilder stringBuilder = new StringBuilder();
        if (entry.getKey() instanceof NamedElement) {
            List shortestQualifiedNames;
            if (!(entry.getKey() instanceof Stereotype)) {
                stringBuilder.append("_label_");
            }
            Resource umlResource = ((NamedElement)entry.getKey()).eResource();
            Namespace superElementInSameResource = null;
            if (umlResource != null) {
                for (EObject eObjectContent : umlResource.getContents()) {
                    if (!(eObjectContent instanceof Namespace) || !EcoreUtil.isAncestor((EObject)eObjectContent, (EObject)((NamedElement)entry.getKey()))) continue;
                    superElementInSameResource = (Namespace)eObjectContent;
                }
            }
            boolean shortestQualifiedNameUsed = false;
            if (superElementInSameResource != null && superElementInSameResource.eContainer() != null && !(shortestQualifiedNames = NameResolutionUtils.getShortestQualifiedNames((NamedElement)((NamedElement)entry.getKey()), (Namespace)((Namespace)superElementInSameResource.eContainer()), (boolean)false)).isEmpty()) {
                stringBuilder.append(((String)shortestQualifiedNames.get(0)).replaceAll("::", QUALIFIED_NAME_SEPARATOR_REPLACEMENT));
                shortestQualifiedNameUsed = true;
            }
            if (!shortestQualifiedNameUsed) {
                stringBuilder.append(UMLQualifiedNameUtils.getQualifiedName((NamedElement)((NamedElement)entry.getKey()), (String)QUALIFIED_NAME_SEPARATOR_REPLACEMENT));
            }
        }
        return stringBuilder.length() != 0 ? stringBuilder.toString() : super.getKey(entry);
    }

    public void dispose() {
        this.elementsForQN.clear();
        super.dispose();
    }
}

