/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.drafter.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.uml.profile.drafter.exceptions.NotFoundException;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.papyrus.uml.tools.model.UmlUtils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLMetamodelUtils {
    protected Package umlMetamodel;
    protected List<Class> metaclasses = null;

    public UMLMetamodelUtils(Package umlMetamodel) {
        this.umlMetamodel = umlMetamodel;
    }

    public UMLMetamodelUtils(Element anyUmlElement) throws NotFoundException {
        this(anyUmlElement.eResource().getResourceSet());
    }

    public UMLMetamodelUtils(ResourceSet resourceSet) throws NotFoundException {
        this.umlMetamodel = UMLMetamodelUtils.loadUMLMetamodel(resourceSet);
    }

    public UMLMetamodelUtils(ServicesRegistry servicesRegistry) throws NotFoundException {
        try {
            UmlModel umlModel = UmlUtils.getUmlModelChecked((ServicesRegistry)servicesRegistry);
            this.umlMetamodel = UMLMetamodelUtils.loadUMLMetamodel(umlModel.getResource().getResourceSet());
        }
        catch (ServiceException e) {
            throw new NotFoundException("Can't get the uml model from the ServiceRegistry.");
        }
    }

    public Class getElementMetaclass(Element element) throws NotFoundException {
        return this.getMetaclassFromName(element.eClass().getName());
    }

    public Class getMetaclassFromName(String name) throws NotFoundException {
        for (Class metaclass : this.getMetaclasses()) {
            if (!metaclass.getName().equalsIgnoreCase(name)) continue;
            return metaclass;
        }
        throw new NotFoundException("Can't get uml metaclass for '" + name + "'.");
    }

    public Package getUmlMetamodel() {
        return this.umlMetamodel;
    }

    public List<Class> getMetaclasses() {
        if (this.metaclasses != null) {
            return this.metaclasses;
        }
        this.metaclasses = new ArrayList<Class>();
        for (Type ele : this.getUmlMetamodel().getOwnedTypes()) {
            if (!(ele instanceof Class)) continue;
            this.metaclasses.add((Class)ele);
        }
        return this.metaclasses;
    }

    public static Package loadUMLMetamodel(ResourceSet resourceSet) throws NotFoundException {
        URI uri = URI.createURI((String)"pathmap://UML_METAMODELS/UML.metamodel.uml");
        Package package_ = null;
        try {
            Resource resource = resourceSet.getResource(uri, true);
            package_ = (Package)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)UMLPackage.eINSTANCE.getPackage());
        }
        catch (WrappedException we) {
            throw new NotFoundException("Can't load uml metamodel.", we);
        }
        return package_;
    }
}

