/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.architecture.merged;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.architecture.commands.IModelConversionCommand;
import org.eclipse.papyrus.infra.architecture.commands.IModelCreationCommand;
import org.eclipse.papyrus.infra.core.architecture.ADElement;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.ArchitecturePackage;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedADElement;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureViewpoint;
import org.eclipse.papyrus.infra.core.architecture.util.MergeTraceAdapter;
import org.eclipse.papyrus.infra.tools.util.ClassLoaderHelper;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;

public abstract class MergedArchitectureContext
extends MergedADElement {
    private final EList<MergedArchitectureViewpoint> viewpoints = new UniqueEList();
    private EList<MergedArchitectureViewpoint> defaultViewpoints;

    @Deprecated(since="3.1", forRemoval=true)
    public MergedArchitectureContext(MergedArchitectureDomain domain) {
        this(domain, null);
    }

    public MergedArchitectureContext(MergedArchitectureDomain domain, ArchitectureContext context) {
        super(domain, (ADElement)context);
        domain.addContext(this);
    }

    protected ArchitectureContext getModel() {
        return (ArchitectureContext)super.getModel();
    }

    public String getExtensionPrefix() {
        return this.getModel().getExtensionPrefix();
    }

    public Class<? extends IModelCreationCommand> getCreationCommandClass() throws ClassNotFoundException {
        String className = this.getCreationCommandClassName();
        return className == null ? null : ClassLoaderHelper.loadClass((String)className, IModelCreationCommand.class, (URI)EcoreUtil.getURI((EObject)MergeTraceAdapter.getSource((ADElement)this.getModel(), (EStructuralFeature)ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__CREATION_COMMAND_CLASS)));
    }

    public Class<? extends IModelConversionCommand> getConversionCommandClass() throws ClassNotFoundException {
        String className = this.getConversionCommandClassName();
        return className == null ? null : ClassLoaderHelper.loadClass((String)className, IModelConversionCommand.class, (URI)EcoreUtil.getURI((EObject)MergeTraceAdapter.getSource((ADElement)this.getModel(), (EStructuralFeature)ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__CONVERSION_COMMAND_CLASS)));
    }

    public String getCreationCommandClassName() {
        return this.getModel().getCreationCommandClass();
    }

    public String getConversionCommandClassName() {
        return this.getModel().getConversionCommandClass();
    }

    public MergedArchitectureDomain getDomain() {
        return (MergedArchitectureDomain)this.getParent();
    }

    public Collection<ElementTypeSetConfiguration> getElementTypes() {
        return ECollections.unmodifiableEList((EList)this.getModel().getElementTypes());
    }

    public Collection<MergedArchitectureViewpoint> getViewpoints() {
        return ECollections.unmodifiableEList(this.viewpoints);
    }

    final void addViewpoint(MergedArchitectureViewpoint viewpoint) {
        this.viewpoints.add((Object)viewpoint);
        this.defaultViewpoints = null;
    }

    public Collection<MergedArchitectureViewpoint> getDefaultViewpoints() {
        if (this.defaultViewpoints == null) {
            Map map = this.getViewpoints().stream().collect(Collectors.toMap(MergedArchitectureViewpoint::getModel, Function.identity()));
            this.defaultViewpoints = (EList)this.getModel().getDefaultViewpoints().stream().map(map::get).filter(Objects::nonNull).collect(Collectors.toCollection(UniqueEList::new));
        }
        return ECollections.unmodifiableEList(this.defaultViewpoints);
    }

    final void addDefaultViewpoint(MergedArchitectureViewpoint viewpoint) {
        this.defaultViewpoints.add((Object)viewpoint);
    }
}

