/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.assistant.internal.core.util;

import com.google.common.base.Function;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.IModelingAssistantOperation;
import org.eclipse.papyrus.infra.gmfdiag.assistant.ModelingAssistantProvider;
import org.eclipse.uml2.common.util.CacheAdapter;

public class ProviderCache<I, T> {
    private final Function<? super I, ? extends T> cacheFunction;
    private Reference<I> ref;
    private T cache;

    private ProviderCache(Function<? super I, ? extends T> cacheFunction) {
        this.cacheFunction = cacheFunction;
    }

    public static <I, T> ProviderCache<I, T> getCache(ModelingAssistantProvider provider, Class<? extends IModelingAssistantOperation> key) {
        ProviderCache result = null;
        CacheAdapter adapter = CacheAdapter.getCacheAdapter((Notifier)provider);
        if (adapter != null) {
            result = (ProviderCache)adapter.get((EObject)provider, key);
        }
        return result;
    }

    public static <I, T> ProviderCache<I, T> cache(ModelingAssistantProvider provider, Class<? extends IModelingAssistantOperation> key, Function<? super I, ? extends T> cacheFunction) {
        ProviderCache<? super I, ? extends T> result = new ProviderCache<I, T>(cacheFunction);
        CacheAdapter adapter = CacheAdapter.getCacheAdapter((Notifier)provider);
        if (adapter != null) {
            adapter.put((EObject)provider, key, result);
        }
        return result;
    }

    public T get(I input) {
        Object lastKnown;
        Object result = null;
        Object v0 = lastKnown = this.ref != null ? this.ref.get() : null;
        if (input == lastKnown) {
            result = this.cache;
        } else {
            result = this.cacheFunction.apply(input);
            this.ref = new WeakReference<I>(input);
            this.cache = result;
        }
        return (T)result;
    }
}

