/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.textedit.xtext.internal.listeners;

import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.textedit.xtext.internal.command.TextUndoRedoCommandWrapper;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;

public class UndoableTextChangeListener
implements IOperationHistoryListener {
    private static final String UNDOABLE_TEXT_CHANGE_CLASS = "org.eclipse.text.undo.DocumentUndoManager.UndoableTextChange";
    private static final String UNDOABLE_COMPOUND_TEXT_CHANGE_CLASS = "org.eclipse.text.undo.DocumentUndoManager.UndoableCompoundTextChange";
    private TransactionalEditingDomain domain;
    private IXtextDocument xTextDocument;
    private boolean active = true;

    public UndoableTextChangeListener(TransactionalEditingDomain domain, IXtextDocument xTextDocument) {
        this.domain = domain;
        this.xTextDocument = xTextDocument;
    }

    public void updateXTextDocument(IXtextDocument xTextDocument) {
        this.xTextDocument = xTextDocument;
    }

    public void enable() {
        this.active = true;
    }

    public void disable() {
        this.active = false;
    }

    public void historyNotification(OperationHistoryEvent event) {
        int eventType = event.getEventType();
        IUndoableOperation operation = event.getOperation();
        String operationClassName = operation.getClass().getCanonicalName();
        if ((UNDOABLE_TEXT_CHANGE_CLASS.equals(operationClassName) || UNDOABLE_COMPOUND_TEXT_CHANGE_CLASS.equals(operationClassName)) && eventType == 5) {
            if (!this.active) {
                return;
            }
            if (this.xTextDocument == this.extractCurrentXTextDocument(operation)) {
                TextUndoRedoCommandWrapper lastCreatedWrapper = new TextUndoRedoCommandWrapper(operation);
                this.domain.getCommandStack().execute((Command)lastCreatedWrapper);
            }
        }
    }

    private IXtextDocument extractCurrentXTextDocument(IUndoableOperation operation) {
        IUndoContext[] iUndoContextArray = operation.getContexts();
        int n = iUndoContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectUndoContext undoContext;
            IUndoContext ctx = iUndoContextArray[n2];
            if (ctx instanceof ObjectUndoContext && (undoContext = (ObjectUndoContext)ctx).getObject() instanceof IXtextDocument) {
                return (IXtextDocument)undoContext.getObject();
            }
            ++n2;
        }
        return null;
    }
}

