/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelrepair.internal.uripattern;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;

public class ProfileNamespaceURIPatternMatchResult {
    public static final ProfileNamespaceURIPatternMatchResult NO_MATCH = new ProfileNamespaceURIPatternMatchResult(null, null);
    private MatchResult regexMatchResult;
    private MessageFormat versionFormat;
    private String[] groups;
    private String[] nonGroups;
    private String namespaceURI;
    private String versionlessNamespaceURI;
    private String version;

    public ProfileNamespaceURIPatternMatchResult(Matcher matcher) {
        this(matcher, null);
    }

    public ProfileNamespaceURIPatternMatchResult(Matcher matcher, MessageFormat versionFormat) {
        if (matcher != null && matcher.matches()) {
            this.regexMatchResult = matcher.toMatchResult();
            this.versionFormat = versionFormat;
        }
    }

    public MessageFormat getVersionFormat() {
        return this.versionFormat;
    }

    public boolean hasMatched() {
        return this.getRegexMatchResult() != null;
    }

    public String getNamespaceURI() {
        if (!this.hasMatched()) {
            return null;
        }
        if (this.namespaceURI == null) {
            this.namespaceURI = this.getRegexMatchResult().group(0);
        }
        return this.namespaceURI;
    }

    public String getVersionlessNamespaceURI() {
        if (!this.hasMatched()) {
            return null;
        }
        if (this.versionlessNamespaceURI == null) {
            this.versionlessNamespaceURI = String.join((CharSequence)"", this.getNonGroups());
        }
        return this.versionlessNamespaceURI;
    }

    public String getVersion() {
        if (!this.hasMatched()) {
            return null;
        }
        if (this.version == null) {
            this.version = this.versionFormat != null ? this.versionFormat.format(this.getGroups()) : String.join((CharSequence)",", Arrays.copyOfRange(this.getGroups(), 1, this.getGroups().length));
        }
        return this.version;
    }

    protected MatchResult getRegexMatchResult() {
        return this.regexMatchResult;
    }

    protected String[] getGroups() {
        if (!this.hasMatched()) {
            return null;
        }
        if (this.groups == null) {
            int groupCount = this.getRegexMatchResult().groupCount();
            this.groups = new String[groupCount + 1];
            int i = 0;
            while (i <= groupCount) {
                this.groups[i] = this.getRegexMatchResult().group(i);
                ++i;
            }
        }
        return this.groups;
    }

    protected String[] getNonGroups() {
        if (!this.hasMatched()) {
            return null;
        }
        if (this.nonGroups == null) {
            String nonGroup;
            int groupCount = this.getRegexMatchResult().groupCount();
            ArrayList<String> nonGroupList = new ArrayList<String>();
            int start = this.getRegexMatchResult().start();
            int i = 1;
            while (i <= groupCount) {
                nonGroup = this.getNamespaceURI().substring(start, this.getRegexMatchResult().start(i));
                if (!nonGroup.isEmpty()) {
                    nonGroupList.add(nonGroup);
                }
                start = this.getRegexMatchResult().end(i);
                ++i;
            }
            nonGroup = this.getNamespaceURI().substring(start, this.getRegexMatchResult().end());
            if (!nonGroup.isEmpty()) {
                nonGroupList.add(nonGroup);
            }
            this.nonGroups = nonGroupList.toArray(new String[nonGroupList.size()]);
        }
        return this.nonGroups;
    }

    public String toString() {
        if (!this.hasMatched()) {
            return "No match.";
        }
        return this.getVersionlessNamespaceURI() + " [" + this.getVersion() + "]";
    }
}

