/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.commands;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrus.commands.CreationCommandDescriptor;
import org.eclipse.papyrus.commands.CreationCommandExtensionFactory;
import org.eclipse.papyrus.commands.ICreationCommand;
import org.eclipse.papyrus.commands.ICreationCommandRegistry;
import org.eclipse.papyrus.infra.core.extension.ExtensionException;
import org.eclipse.papyrus.infra.core.extension.NotFoundException;

public class CreationCommandRegistry
implements ICreationCommandRegistry {
    private static Map<String, CreationCommandRegistry> registriesMap = new HashMap<String, CreationCommandRegistry>();
    public static final String EDITOR_EXTENSION_ID = "papyrusDiagram";
    protected String extensionPointNamespace;
    private String icon;
    private Map<Object, CreationCommandDescriptor> creationCommandDescriptors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CreationCommandRegistry getInstance(String extensionPointNamespace) {
        Map<String, CreationCommandRegistry> map = registriesMap;
        synchronized (map) {
            CreationCommandRegistry registry = registriesMap.get(extensionPointNamespace);
            if (registry == null) {
                registry = new CreationCommandRegistry(extensionPointNamespace);
                registriesMap.put(extensionPointNamespace, registry);
            }
            return registry;
        }
    }

    private CreationCommandRegistry(String extensionPointNamespace) {
        this.extensionPointNamespace = extensionPointNamespace;
        this.initializeCreationCommandDescriptors();
    }

    @Override
    public Collection<CreationCommandDescriptor> getCommandDescriptors() {
        return this.creationCommandDescriptors.values();
    }

    @Override
    public ICreationCommand getCommand(String commandId) throws NotFoundException {
        try {
            CreationCommandDescriptor desc = this.creationCommandDescriptors.get(commandId);
            return desc.getCommand();
        }
        catch (Exception e) {
            throw new NotFoundException("No creation command registered under id '" + commandId + "'.");
        }
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    private void initializeCreationCommandDescriptors() {
        this.creationCommandDescriptors = new HashMap<Object, CreationCommandDescriptor>();
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(this.extensionPointNamespace, EDITOR_EXTENSION_ID);
        CreationCommandExtensionFactory extensionReader = new CreationCommandExtensionFactory();
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ele = iConfigurationElementArray[n2];
            try {
                if ("creationCommand".equals(ele.getName())) {
                    CreationCommandDescriptor desc = extensionReader.createCreationCommand(ele);
                    this.creationCommandDescriptors.put(desc.commandId, desc);
                }
            }
            catch (ExtensionException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.papyrus.infra.gmfdiag.commands", e.getMessage(), (Throwable)e));
                Activator.log.error("Initialization creation command problem ", (Throwable)e);
            }
            ++n2;
        }
        Activator.log.debug(this.creationCommandDescriptors.size() + " creationCommands loaded");
    }
}

