/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.papyrusgmfgenextension.popupaction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.Palette;
import org.eclipse.gmf.codegen.gmfgen.ToolEntry;
import org.eclipse.gmf.codegen.gmfgen.ToolGroup;
import org.eclipse.gmf.codegen.gmfgen.ToolGroupItem;
import org.eclipse.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.papyrusgmfgenextension.popupaction.Action;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AddSmallAndLargeIconForPaletteAction
extends Action {
    protected List<String> messages = new ArrayList<String>();
    protected int modifiedElements = 0;

    public void run(IAction action) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        this.messages.clear();
        this.modifiedElements = 0;
        for (EObject eObject : this.getSelectedEObject()) {
            if (eObject instanceof Palette) {
                monitor.beginTask("Generate palette icons", -1);
                this.generateIconsForEntry((Palette)eObject, (IProgressMonitor)monitor);
            } else if (eObject instanceof ToolGroup) {
                monitor.beginTask("Generate group icons", -1);
                this.generateIconsForGroup((ToolGroup)eObject, (IProgressMonitor)monitor);
            } else if (eObject instanceof ToolEntry) {
                monitor.beginTask("Generate entry icons", -1);
                this.generateIconsForEntry((ToolEntry)eObject, (IProgressMonitor)monitor);
            }
            try {
                eObject.eResource().save(new HashMap());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (this.messages.isEmpty()) continue;
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Information", (String)this.messages.toString());
            System.err.println(this.messages);
        }
    }

    private void generateIconsForGroup(ToolGroup group, IProgressMonitor monitor) {
        if (group.getSmallIconPath() == null) {
            group.setSmallIconPath("platform:/plugin/org.eclipse.gmf.runtime.diagram.ui/icons/group.gif");
            this.messages.add("INFO: added small icon for " + group);
            ++this.modifiedElements;
        }
        if (group.getLargeIconPath() == null) {
            group.setLargeIconPath("platform:/plugin/org.eclipse.gmf.runtime.diagram.ui/icons/group.gif");
            this.messages.add("INFO: added large icon for " + group);
        }
        monitor.subTask("Generate group entries icons");
        for (ToolGroupItem entry : group.getEntries()) {
            if (!(entry instanceof ToolEntry)) continue;
            this.generateIconsForEntry((ToolEntry)entry, monitor);
        }
    }

    private void generateIconsForEntry(Palette eObject, IProgressMonitor monitor) {
        Iterator it = eObject.getGroups().iterator();
        while (it.hasNext()) {
            this.generateIconsForGroup((ToolGroup)it.next(), monitor);
        }
    }

    private void generateIconsForEntry(ToolEntry toolEntry, IProgressMonitor monitor) {
        EList list = toolEntry.getElements();
        GenClass genClass = null;
        String name = "";
        if (!list.isEmpty()) {
            TypeModelFacet facet;
            GenCommonBase base = (GenCommonBase)list.get(0);
            if (base instanceof GenNode) {
                facet = ((GenNode)base).getModelFacet();
                if (facet != null) {
                    genClass = facet.getMetaClass();
                }
            } else if (base instanceof GenLink && (facet = ((GenLink)base).getModelFacet()) instanceof TypeLinkModelFacet) {
                genClass = ((TypeLinkModelFacet)facet).getMetaClass();
            }
        }
        if (genClass == null) {
            this.messages.add("ERROR: " + toolEntry + " : impossible to find its gen class associated");
            return;
        }
        if (genClass != null) {
            name = genClass.getName();
        }
        assert (name != null) : "impossible to find a name for model element: " + toolEntry;
        String smallIconPath = "";
        if (!this.getEclassPackageNsURI(genClass).equals("http://www.eclipse.org/uml2/3.0.0/UML")) {
            return;
        }
        smallIconPath = "platform:/plugin/org.eclipse.uml2.uml.edit/icons/full/obj16/" + name + ".gif";
        String largeIconPath = smallIconPath;
        if (toolEntry.getSmallIconPath() == null || "".equals(toolEntry.getSmallIconPath())) {
            toolEntry.setSmallIconPath(smallIconPath);
            ++this.modifiedElements;
        } else {
            this.messages.add("INFO: " + toolEntry + " small icon field was not modified because it was already filled");
        }
        if (toolEntry.getLargeIconPath() == null || "".equals(toolEntry.getLargeIconPath())) {
            toolEntry.setLargeIconPath(largeIconPath);
            this.messages.add("INFO: " + toolEntry + " large icon field was not modified because it was already filled");
        }
        monitor.worked(1);
    }

    private String getEclassPackageNsURI(GenClass genClass) {
        EClass eClass = genClass.getEcoreClass();
        if (eClass != null) {
            EPackage ePackage = eClass.getEPackage();
            if (ePackage != null) {
                return ePackage.getNsURI() != null ? ePackage.getNsURI() : "";
            }
            this.messages.add("ERROR: " + eClass + " has no associated epackage");
        } else {
            this.messages.add("ERROR: " + genClass + " has no ecore class");
        }
        return "";
    }
}

