/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.profile.internal.checkers;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.URIMappingRegistryImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.MarkersService;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.ProjectManagementService;

public class ProfileDependenciesChecker
implements IPluginChecker {
    private static Set<String> WARNING_PLUGINS_EXCEPTION = new HashSet<String>(){
        {
            this.add("org.eclipse.uml2.uml.resources");
        }
    };
    private final IProject project;
    private final IFile profileFile;
    private final Resource resource;

    public ProfileDependenciesChecker(IProject project, IFile profileFile, Resource resource) {
        this.project = project;
        this.profileFile = profileFile;
        this.resource = resource;
    }

    public void check(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.subTask("Validate dependencies for profile '" + this.profileFile.getName() + "'.");
        }
        Collection<URI> externalReferencesPaths = this.getExternalReferencesPaths(this.project, this.profileFile, this.resource);
        HashSet<String> requiredPlugins = new HashSet<String>();
        externalReferencesPaths.stream().forEach(externalReferencePath -> {
            boolean bl = requiredPlugins.add(this.getPluginNameFromURI((URI)externalReferencePath));
        });
        HashSet existingRequiredPlugins = new HashSet();
        List dependencies = ProjectManagementService.getPluginDependencies((IProject)this.project);
        if (dependencies != null && !dependencies.isEmpty()) {
            ProjectManagementService.getPluginDependencies((IProject)this.project).stream().forEach(dependency -> {
                boolean bl = existingRequiredPlugins.add(dependency.getName());
            });
            requiredPlugins.removeIf(requiredPlugin -> existingRequiredPlugins.contains(requiredPlugin));
        }
        if (!requiredPlugins.isEmpty()) {
            IFile manifestFile = ProjectManagementService.getManifestFile((IContainer)this.project);
            requiredPlugins.stream().forEach(requiredPlugin -> {
                int severity = 2;
                if (WARNING_PLUGINS_EXCEPTION.contains(requiredPlugin)) {
                    severity = 1;
                }
                MarkersService.createMarker((IResource)manifestFile, (String)"org.eclipse.papyrus.toolsmiths.validation.profile.diagnostic", (String)("The plug-in '" + requiredPlugin + "' must be defined as required plug-in (for profile '" + this.profileFile.getName() + "')."), (int)severity);
            });
        }
        if (monitor != null) {
            monitor.worked(1);
        }
    }

    private Collection<URI> getExternalReferencesPaths(IProject project, IFile profileFile, Resource resource) {
        HashSet<URI> externalReferencesPaths = new HashSet<URI>();
        EcoreUtil.resolveAll((Resource)resource);
        for (Resource currentResource : resource.getResourceSet().getResources()) {
            if (!this.isExternalReferenceToManage(project, currentResource)) continue;
            URI resourceURI = currentResource.getURI();
            if (resourceURI.toString().startsWith("pathmap://")) {
                URI correspondingURI = this.getCorrespondingURIFromPathmap(resourceURI);
                if (correspondingURI == null) {
                    MarkersService.createMarker((IResource)profileFile, (String)"org.eclipse.papyrus.toolsmiths.validation.profile.diagnostic", (String)("The pathmap '" + resourceURI.toString() + "' cannot be resolved."), (int)2);
                    continue;
                }
                externalReferencesPaths.add(correspondingURI);
                continue;
            }
            externalReferencesPaths.add(resourceURI);
        }
        return externalReferencesPaths;
    }

    private boolean isExternalReferenceToManage(IProject project, Resource resource) {
        String resourceURI = resource.getURI().toString();
        return !resourceURI.startsWith("platform:/plugin/" + project.getName() + "/") && !resourceURI.startsWith("platform:/resource/" + project.getName() + "/");
    }

    private URI getCorrespondingURIFromPathmap(URI uri) {
        URI copiedURI = URI.createURI((String)uri.toString());
        URI foundCorrespondingURI = null;
        while (foundCorrespondingURI == null) {
            foundCorrespondingURI = (URI)URIMappingRegistryImpl.INSTANCE.get((Object)copiedURI);
            if (foundCorrespondingURI != null) continue;
            if (copiedURI.segmentCount() <= 0) break;
            copiedURI = copiedURI.trimSegments(1);
        }
        return foundCorrespondingURI;
    }

    private String getPluginNameFromURI(URI uri) {
        int takenSegment;
        String pluginName = null;
        int n = takenSegment = uri.hasAuthority() ? 0 : 1;
        if (uri.segmentCount() > takenSegment) {
            pluginName = uri.segment(takenSegment);
        }
        return pluginName;
    }
}

