/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.framework.classification;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.operations.DefaultOperationHistory;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.papyrus.infra.tools.util.ListHelper;
import org.eclipse.papyrus.junit.framework.classification.ClassificationConfig;
import org.eclipse.papyrus.junit.framework.classification.rules.ConditionRule;
import org.eclipse.papyrus.junit.framework.classification.rules.Conditional;
import org.eclipse.papyrus.junit.framework.classification.rules.MemoryLeakRule;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

class ClassificationRunnerImpl {
    private static final long EVENT_LOOP_TIMEOUT = 120000L;
    private static final long ONE_MB = 0x100000L;
    private static final Supplier<TestRule> uiFlusherRuleSupplier = ClassificationRunnerImpl.createUIFlusherRuleSupplier();
    private final ThreadLocal<Object> preparedTest = new ThreadLocal();
    private final Delegate delegate;

    ClassificationRunnerImpl(Delegate delegate) throws InitializationError {
        this.delegate = delegate;
    }

    final void runChild(FrameworkMethod method, RunNotifier notifier) {
        List allAnnotations = ListHelper.asList((Object[])method.getAnnotations());
        allAnnotations.addAll(Arrays.asList(method.getMethod().getDeclaringClass().getAnnotations()));
        if (ClassificationConfig.shouldRun(allAnnotations.toArray(new Annotation[allAnnotations.size()])) && this.conditionSatisfied(method)) {
            this.delegate.runChild(method, notifier);
        } else {
            Description description = this.delegate.describeChild(method);
            notifier.fireTestIgnored(description);
        }
    }

    final Object createTest() throws Exception {
        Object result = this.preparedTest.get();
        if (result != null) {
            this.clearPreparedTest();
        } else {
            result = this.delegate.createTest();
        }
        return result;
    }

    final Object prepareTest() throws Exception {
        Object result = this.delegate.createTest();
        this.preparedTest.set(result);
        return result;
    }

    final void clearPreparedTest() {
        this.preparedTest.remove();
    }

    private boolean conditionSatisfied(FrameworkMethod method) {
        boolean result = true;
        Conditional conditional = (Conditional)method.getAnnotation(Conditional.class);
        if (conditional != null) {
            try {
                try {
                    Object test = this.prepareTest();
                    result = ConditionRule.testCondition(method.getMethod().getDeclaringClass(), conditional, test);
                }
                catch (Throwable t) {
                    result = false;
                    if (!result) {
                        this.clearPreparedTest();
                    }
                }
            }
            finally {
                if (!result) {
                    this.clearPreparedTest();
                }
            }
        }
        return result;
    }

    List<TestRule> getTestRules(Object target) {
        return this.reorderForMemoryLeakRules(this.delegate.getTestRules(target));
    }

    private List<TestRule> reorderForMemoryLeakRules(List<TestRule> rules) {
        int memoryRuleCount;
        if (!rules.isEmpty() && (memoryRuleCount = Iterables.size((Iterable)Iterables.filter(rules, (Predicate)Predicates.instanceOf(MemoryLeakRule.class)))) > 0) {
            int limit = rules.size() - memoryRuleCount;
            int i = 0;
            while (i < limit) {
                if (rules.get(i) instanceof MemoryLeakRule) {
                    rules.add(rules.remove(i--));
                }
                ++i;
            }
        }
        return rules;
    }

    Statement classBlock(RunNotifier notifier) {
        Statement result = this.delegate.classBlock(notifier);
        TestRule uiFlusher = (TestRule)uiFlusherRuleSupplier.get();
        if (uiFlusher != null) {
            result = uiFlusher.apply(result, Description.EMPTY);
        }
        return result;
    }

    private static Supplier<TestRule> createUIFlusherRuleSupplier() {
        Supplier result = Suppliers.ofInstance(null);
        try {
            if (PlatformUI.isWorkbenchRunning()) {
                result = Suppliers.memoize((Supplier)new Supplier<TestRule>(){

                    public TestRule get() {
                        if (Display.getCurrent() != null) {
                            return new TestWatcher(){

                                protected void finished(Description description) {
                                    Display display = Display.getCurrent();
                                    if (display == null) {
                                        return;
                                    }
                                    ClassificationRunnerImpl.flushUIEventQueue(display);
                                    ClassificationRunnerImpl.purgeZombieHistoryListeners();
                                    ClassificationRunnerImpl.clearDecorationScheduler();
                                }
                            };
                        }
                        return null;
                    }
                });
            }
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        return result;
    }

    private static void flushUIEventQueue(Display display) {
        long base = System.currentTimeMillis();
        long timeout = 120000L;
        while (!display.isDisposed()) {
            long now;
            try {
                if (!display.readAndDispatch()) {
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ((now = System.currentTimeMillis()) - base <= timeout) continue;
            base = now;
            timeout = timeout * 3L / 2L;
            int freeMB = (int)(Runtime.getRuntime().freeMemory() / 0x100000L);
            System.err.printf("========%nUI event queue clean-up seems to be running long.%nCurrent free memory: %d MB%n========%n%n", freeMB);
        }
    }

    private static void purgeZombieHistoryListeners() {
        IWorkbenchWindow window;
        IWorkbench bench = PlatformUI.getWorkbench();
        IWorkbenchWindow iWorkbenchWindow = window = bench == null ? null : bench.getActiveWorkbenchWindow();
        if (window == null && bench != null && bench.getWorkbenchWindowCount() > 0) {
            window = bench.getWorkbenchWindows()[0];
        }
        if (window != null && window.getActivePage().getEditorReferences().length == 0) {
            ListenerList historyListeners = OperationHistoryHelper.getOperationHistoryListeners();
            Object[] listeners = historyListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                if (OperationHistoryHelper.shouldRemoveHistoryListener(listeners[i])) {
                    historyListeners.remove(listeners[i]);
                }
                ++i;
            }
        }
    }

    private static void clearDecorationScheduler() {
        IWorkbench bench = PlatformUI.getWorkbench();
        if (bench != null) {
            BaseLabelProvider bogusProvider = new BaseLabelProvider();
            try {
                ((ILabelProviderListener)bench.getDecoratorManager()).labelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)bogusProvider));
            }
            finally {
                bogusProvider.dispose();
            }
        }
    }

    static interface Delegate {
        public void runChild(FrameworkMethod var1, RunNotifier var2);

        public Description describeChild(FrameworkMethod var1);

        public Object createTest() throws Exception;

        public List<TestRule> getTestRules(Object var1);

        public Statement classBlock(RunNotifier var1);
    }

    static class OperationHistoryHelper {
        static final Field listenersField;
        static final Set<Class<?>> historyListenerClasses;

        static {
            try {
                listenersField = DefaultOperationHistory.class.getDeclaredField("listeners");
                listenersField.setAccessible(true);
                historyListenerClasses = Sets.newHashSet((Object[])new Class[]{Platform.getBundle((String)"org.eclipse.gmf.runtime.diagram.ui.actions").loadClass("org.eclipse.gmf.runtime.diagram.ui.actions.internal.PropertyChangeContributionItem"), Platform.getBundle((String)"org.eclipse.ui.workbench").loadClass("org.eclipse.ui.operations.OperationHistoryActionHandler$HistoryListener")});
            }
            catch (Exception e) {
                throw new ExceptionInInitializerError(e);
            }
        }

        OperationHistoryHelper() {
        }

        static ListenerList getOperationHistoryListeners() {
            try {
                return (ListenerList)listenersField.get(PlatformUI.getWorkbench().getOperationSupport().getOperationHistory());
            }
            catch (Exception e) {
                Assert.fail((String)e.getLocalizedMessage());
                return null;
            }
        }

        static boolean shouldRemoveHistoryListener(Object listener) {
            boolean result = historyListenerClasses.contains(listener.getClass().getName());
            if (!result) {
                for (Class<?> next : historyListenerClasses) {
                    if (!next.isInstance(listener)) continue;
                    historyListenerClasses.add(listener.getClass());
                    result = true;
                    break;
                }
            }
            return result;
        }
    }
}

