/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.validation.internal;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.services.validation.Activator;
import org.eclipse.papyrus.infra.services.validation.IPapyrusDiagnostician;
import org.eclipse.papyrus.infra.services.validation.IValidationFilter;
import org.eclipse.papyrus.infra.services.validation.IValidationHook;
import org.eclipse.papyrus.infra.services.validation.internal.EcoreDiagnostician;

public class ValidationRegistry {
    public static final String ID_DIAGNOSTICIANS = "org.eclipse.papyrus.infra.services.validation.diagnosticians";
    public static final String ID_VALIDATION_HOOKS = "org.eclipse.papyrus.infra.services.validation.validationHooks";
    public static final String DIAGNOSTICIAN = "diagnostician";
    public static final String VALIDATION_HOOK = "hook";
    public static final String FILTER = "filter";
    private static final String PRIORITY = "priority";

    public static IPapyrusDiagnostician getDiagnostician(EObject element) {
        IConfigurationElement[] configElements;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = configElements = ValidationRegistry.sort(reg.getConfigurationElementsFor(ID_DIAGNOSTICIANS));
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            try {
                Object diagnostician;
                IValidationFilter filter;
                Object obj = configElement.createExecutableExtension(FILTER);
                if (obj instanceof IValidationFilter && (filter = (IValidationFilter)obj).isApplicable(element) && (diagnostician = configElement.createExecutableExtension(DIAGNOSTICIAN)) instanceof IPapyrusDiagnostician) {
                    return (IPapyrusDiagnostician)diagnostician;
                }
            }
            catch (CoreException exception) {
                Activator.log.error((Throwable)exception);
            }
            ++n2;
        }
        return new EcoreDiagnostician();
    }

    private static IConfigurationElement[] sort(IConfigurationElement[] configElements) {
        Comparator<IConfigurationElement> byPriority = new Comparator<IConfigurationElement>(){
            private Map<IConfigurationElement, Priority> priorities = new HashMap<IConfigurationElement, Priority>();

            Priority getPriority(IConfigurationElement config) {
                Priority result = this.priorities.get(config);
                if (result == null) {
                    String priorityName = config.getAttribute(ValidationRegistry.PRIORITY);
                    priorityName = priorityName == null ? Priority.DEFAULT.name() : priorityName.toUpperCase();
                    try {
                        result = Priority.valueOf(priorityName);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (result == null) {
                        result = Priority.DEFAULT;
                    }
                    this.priorities.put(config, result);
                }
                return result;
            }

            @Override
            public int compare(IConfigurationElement o1, IConfigurationElement o2) {
                return this.getPriority(o2).compareTo(this.getPriority(o1));
            }
        };
        Arrays.sort(configElements, byPriority);
        return configElements;
    }

    public static IPapyrusDiagnostician getDiagnostician(String languageID) {
        IConfigurationElement[] configElements;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = configElements = reg.getConfigurationElementsFor(ID_DIAGNOSTICIANS);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            try {
                Object obj;
                String iConfiguratorIDext = configElement.getAttribute("id");
                if (iConfiguratorIDext != null && iConfiguratorIDext.equals(languageID) && (obj = configElement.createExecutableExtension("class")) instanceof IPapyrusDiagnostician) {
                    return (IPapyrusDiagnostician)obj;
                }
            }
            catch (CoreException exception) {
                Activator.log.error((Throwable)exception);
            }
            ++n2;
        }
        return null;
    }

    public static void executeHooks(EObject element, HookType hookType) {
        IConfigurationElement[] configElements;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = configElements = reg.getConfigurationElementsFor(ID_VALIDATION_HOOKS);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            try {
                Object hookObj;
                IValidationFilter filter;
                Object obj = configElement.createExecutableExtension(FILTER);
                if (obj instanceof IValidationFilter && (filter = (IValidationFilter)obj).isApplicable(element) && (hookObj = configElement.createExecutableExtension(VALIDATION_HOOK)) instanceof IValidationHook) {
                    IValidationHook validationHook = (IValidationHook)hookObj;
                    if (hookType == HookType.BEFORE) {
                        validationHook.beforeValidation(element);
                    } else if (hookType == HookType.AFTER) {
                        validationHook.afterValidation(element);
                    }
                }
            }
            catch (CoreException exception) {
                Activator.log.error((Throwable)exception);
            }
            ++n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HookType {
        BEFORE,
        AFTER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Priority {
        DEFAULT,
        LOWEST,
        LOW,
        NORMAL,
        HIGH,
        HIGHEST;

    }
}

