/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.utilities;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Annotation;
import org.eclipse.ocl.pivot.AnyType;
import org.eclipse.ocl.pivot.AssociationClassCallExp;
import org.eclipse.ocl.pivot.BooleanLiteralExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionItem;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.CollectionLiteralPart;
import org.eclipse.ocl.pivot.CollectionRange;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Comment;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Detail;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ElementExtension;
import org.eclipse.ocl.pivot.EnumLiteralExp;
import org.eclipse.ocl.pivot.EnumerationLiteral;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.FeatureCallExp;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.Import;
import org.eclipse.ocl.pivot.IntegerLiteralExp;
import org.eclipse.ocl.pivot.InvalidLiteralExp;
import org.eclipse.ocl.pivot.InvalidType;
import org.eclipse.ocl.pivot.IterateExp;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.IteratorExp;
import org.eclipse.ocl.pivot.LambdaType;
import org.eclipse.ocl.pivot.LetExp;
import org.eclipse.ocl.pivot.MapLiteralExp;
import org.eclipse.ocl.pivot.MapLiteralPart;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.MessageExp;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Precedence;
import org.eclipse.ocl.pivot.PrimitiveType;
import org.eclipse.ocl.pivot.ProfileApplication;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.RealLiteralExp;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.ShadowPart;
import org.eclipse.ocl.pivot.StateExp;
import org.eclipse.ocl.pivot.StereotypeExtender;
import org.eclipse.ocl.pivot.StringLiteralExp;
import org.eclipse.ocl.pivot.TemplateBinding;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.TemplateableElement;
import org.eclipse.ocl.pivot.TupleLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralPart;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypeExp;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.pivot.UnspecifiedValueExp;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.VoidType;
import org.eclipse.ocl.pivot.WildcardType;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.values.Unlimited;

public class ToStringVisitor
extends AbstractExtendingVisitor<String, StringBuilder> {
    public static boolean SHOW_ALL_MULTIPLICITIES = false;
    private static final Logger logger = Logger.getLogger(ToStringVisitor.class);
    private static @NonNull Map<@NonNull EPackage, @NonNull Factory> factoryMap = new HashMap<EPackage, Factory>();
    public static @NonNull Factory FACTORY = new AS2StringFactory();
    protected static @NonNull String NULL_PLACEHOLDER = "\u00abnull\u00bb";

    public static synchronized void addFactory(@NonNull Factory factory) {
        factoryMap.put(factory.getEPackage(), factory);
    }

    public static synchronized void addFactory(EPackage ePackage, @NonNull Factory factory) {
        assert (ePackage != null);
        factoryMap.put(ePackage, factory);
    }

    public static @Nullable Factory getFactory(@NonNull EObject eObject) {
        EPackage ePackage = eObject.eClass().getEPackage();
        Factory factory = factoryMap.get(ePackage);
        if (factory == null) {
            logger.error((Object)("No ToStringVisitor Factory registered for " + ePackage.getName()));
        }
        return factory;
    }

    public static String toString(@NonNull Element asElement) {
        Resource resource = asElement.eResource();
        if (resource instanceof ASResource) {
            StringBuilder s = new StringBuilder();
            ToStringVisitor v = ((ASResource)resource).getASResourceFactory().createToStringVisitor(s);
            asElement.accept(v);
            return s.toString();
        }
        Factory factory = ToStringVisitor.getFactory(asElement);
        if (factory == null) {
            return NULL_PLACEHOLDER;
        }
        StringBuilder s = new StringBuilder();
        ToStringVisitor v = factory.createToStringVisitor(s);
        asElement.accept(v);
        return s.toString();
    }

    public ToStringVisitor(@NonNull StringBuilder s) {
        super(s);
    }

    protected void append(Number number) {
        if (number != null) {
            ((StringBuilder)this.context).append(number.toString());
        } else {
            ((StringBuilder)this.context).append(NULL_PLACEHOLDER);
        }
    }

    protected void append(String string) {
        if (string != null) {
            ((StringBuilder)this.context).append(string);
        } else {
            ((StringBuilder)this.context).append(NULL_PLACEHOLDER);
        }
    }

    protected void appendAtPre(FeatureCallExp mpc) {
        if (mpc.isIsPre()) {
            this.append("@pre");
        }
    }

    protected void appendElementType(@Nullable TypedElement typedElement) {
        if (typedElement == null) {
            this.append(NULL_PLACEHOLDER);
        } else {
            Type type = typedElement.getType();
            this.safeVisit(type);
            if (!typedElement.isIsRequired()) {
                this.append("[?]");
            } else if (!(type instanceof CollectionType)) {
                this.append("[1]");
            }
        }
    }

    protected void appendName(Nameable object) {
        if (object == null) {
            ((StringBuilder)this.context).append(NULL_PLACEHOLDER);
        } else {
            ((StringBuilder)this.context).append(object.getName());
        }
    }

    protected void appendOperationSignature(Operation operation) {
        this.appendName(operation);
        this.append("(");
        boolean comma = false;
        for (Parameter parm : operation.getOwnedParameters()) {
            if (comma) {
                this.append(", ");
            } else {
                comma = true;
            }
            this.appendName(parm);
            this.append(" : ");
            if (parm.getType() != null) {
                boolean isTypeof = parm.isIsTypeof();
                if (isTypeof) {
                    this.append("typeof(");
                }
                this.appendElementType(parm);
                if (!isTypeof) continue;
                this.append(")");
                continue;
            }
            this.append("OclVoid");
        }
        this.append(") :");
        if (operation.getType() != null) {
            this.append(" ");
            boolean isTypeof = operation.isIsTypeof();
            if (isTypeof) {
                this.append("typeof(");
            }
            this.appendElementType(operation);
            if (isTypeof) {
                this.append(")");
            }
        }
    }

    protected void appendPropertyCallExp(@NonNull NavigationCallExp pc, Property property) {
        OCLExpression source = pc.getOwnedSource();
        this.safeVisit(source);
        Type sourceType = source != null ? source.getType() : null;
        this.append(PivotUtil.getNavigationOperator(pc.isIsSafe(), PivotUtil.isAggregate(sourceType)));
        this.appendName(property);
        this.appendAtPre(pc);
        List<OCLExpression> qualifiers = pc.getQualifiers();
        if (!qualifiers.isEmpty()) {
            this.append("[");
            String prefix = "";
            for (OCLExpression qualifier : qualifiers) {
                this.append(prefix);
                this.safeVisit(qualifier);
                prefix = ", ";
            }
            this.append("]");
        }
    }

    protected void appendPropertySignature(Property property) {
        this.appendName(property);
        if (property.getType() != null) {
            this.append(" : ");
            this.appendElementType(property);
        }
    }

    protected void appendQualifiedName(NamedElement parent, String separator, NamedElement child) {
        if (parent != null) {
            this.appendQualifiedName(parent);
            this.append(separator);
        }
        this.appendName(child);
    }

    protected void appendQualifiedName(@Nullable NamedElement object) {
        if (object == null) {
            ((StringBuilder)this.context).append(NULL_PLACEHOLDER);
        } else {
            EObject container = object.eContainer();
            if (!(container == null || container instanceof Model || !(container instanceof NamedElement) || container.eContainer() instanceof Model && "ocl".equals(((NamedElement)container).getName()))) {
                this.appendQualifiedName((NamedElement)container);
                this.append("::");
            }
            this.appendName(object);
            if (object instanceof TemplateableElement) {
                TemplateableElement templateableElement = (TemplateableElement)((Object)object);
                this.appendTemplateBindings(templateableElement.getOwnedBindings(), null);
                this.appendTemplateSignature(templateableElement.getOwnedSignature());
            }
        }
    }

    protected void appendTemplateBindings(List<TemplateBinding> templateBindings, @Nullable CollectionType collectionType) {
        if (templateBindings.size() > 0) {
            this.append("(");
            String prefix = "";
            for (TemplateBinding templateBinding : templateBindings) {
                for (TemplateParameterSubstitution templateParameterSubstitution : templateBinding.getOwnedSubstitutions()) {
                    this.append(prefix);
                    this.safeVisit(templateParameterSubstitution.getActual());
                    prefix = ",";
                }
            }
            if (collectionType != null) {
                long upperValue;
                Number lower = collectionType.getLower();
                Number upper = collectionType.getUpper();
                long lowerValue = lower != null ? lower.longValue() : 0L;
                long l = upperValue = upper != null && !(upper instanceof Unlimited) ? upper.longValue() : -1L;
                if (SHOW_ALL_MULTIPLICITIES || lowerValue != 0L || upperValue != -1L || !collectionType.isIsNullFree()) {
                    StringUtil.appendMultiplicity((StringBuilder)this.context, lowerValue, upperValue, collectionType.isIsNullFree());
                }
            }
            this.append(")");
        }
    }

    protected void appendTemplateSignature(TemplateSignature templateSignature) {
        List<TemplateParameter> templateParameters;
        if (templateSignature != null && !(templateParameters = templateSignature.getOwnedParameters()).isEmpty()) {
            this.append("(");
            String prefix = "";
            for (TemplateParameter templateParameter : templateParameters) {
                this.append(prefix);
                this.appendName(templateParameter);
                prefix = ",";
            }
            this.append(")");
        }
    }

    protected void appendType(Type type) {
        if (type != null && type.eClass() == PivotPackage.Literals.CLASS && type.eContainer() instanceof NamedElement) {
            this.appendQualifiedName((NamedElement)type.eContainer());
            this.append("::");
        }
        this.appendName(type);
    }

    @Override
    public @Nullable String safeVisit(@Nullable Visitable v) {
        if (v == null) {
            this.append(NULL_PLACEHOLDER);
        } else {
            try {
                v.accept(this);
            }
            catch (ClassCastException e) {
                java.lang.Class<?> thisClass;
                ToStringVisitor stringVisitor2;
                java.lang.Class<?> thatClass;
                Factory factory;
                if (v instanceof EObject && (factory = ToStringVisitor.getFactory((EObject)v)) != null && (thatClass = (stringVisitor2 = factory.createToStringVisitor((StringBuilder)this.context)).getClass()) != (thisClass = this.getClass()) && thisClass.isAssignableFrom(thatClass)) {
                    return stringVisitor2.safeVisit(v);
                }
                this.append("\u00ab");
                this.append(e.getMessage());
                this.append("\u00bb");
            }
            catch (Throwable e) {
                this.append("\u00ab");
                this.append(e.getMessage());
                this.append("\u00bb");
            }
        }
        return null;
    }

    public String toString() {
        return ((StringBuilder)this.context).toString();
    }

    @Override
    public @Nullable String visitAnnotation(@NonNull Annotation object) {
        this.appendName(object);
        return null;
    }

    @Override
    public String visitAnyType(@NonNull AnyType object) {
        this.appendName(object);
        return null;
    }

    @Override
    public String visitAssociationClassCallExp(@NonNull AssociationClassCallExp ac) {
        this.safeVisit(ac.getOwnedSource());
        this.append(".");
        this.appendName(ac.getReferredAssociationClass());
        this.appendAtPre(ac);
        List<OCLExpression> qualifiers = ac.getQualifiers();
        if (!qualifiers.isEmpty()) {
            this.append("[");
            this.safeVisit(qualifiers.get(0));
            this.append("]");
        }
        return null;
    }

    @Override
    public String visitBooleanLiteralExp(@NonNull BooleanLiteralExp bl) {
        this.append(Boolean.toString(bl.isBooleanSymbol()));
        return null;
    }

    @Override
    public String visitClass(@NonNull Class cls) {
        Package pkg = cls.getOwningPackage();
        if (pkg == null) {
            this.append("null::");
            this.appendName(cls);
        } else if (!(pkg.eContainer() instanceof Model) || !IdManager.METAMODEL.equals(pkg.getPackageId())) {
            this.appendQualifiedName(pkg, "::", cls);
        } else {
            this.appendName(cls);
        }
        this.appendTemplateBindings(cls.getOwnedBindings(), null);
        this.appendTemplateSignature(cls.getOwnedSignature());
        return null;
    }

    @Override
    public String visitCollectionItem(@NonNull CollectionItem item) {
        this.safeVisit(item.getOwnedItem());
        return null;
    }

    @Override
    public String visitCollectionLiteralExp(@NonNull CollectionLiteralExp cl) {
        switch (cl.getKind()) {
            case SET: {
                this.append("Set{");
                break;
            }
            case ORDERED_SET: {
                this.append("OrderedSet{");
                break;
            }
            case BAG: {
                this.append("Bag{");
                break;
            }
            case SEQUENCE: {
                this.append("Sequence{");
                break;
            }
            default: {
                this.append("Collection{");
            }
        }
        boolean isFirst = true;
        for (CollectionLiteralPart part : cl.getOwnedParts()) {
            if (!isFirst) {
                this.append(", ");
            }
            this.safeVisit(part);
            isFirst = false;
        }
        this.append("}");
        return null;
    }

    @Override
    public String visitCollectionRange(@NonNull CollectionRange range) {
        this.safeVisit(range.getOwnedFirst());
        this.append(" .. ");
        this.safeVisit(range.getOwnedLast());
        return null;
    }

    @Override
    public String visitCollectionType(@NonNull CollectionType object) {
        this.appendName(object);
        this.appendTemplateBindings(object.getOwnedBindings(), object);
        this.appendTemplateSignature(object.getOwnedSignature());
        return null;
    }

    @Override
    public String visitComment(@NonNull Comment comment) {
        this.append("/* ");
        this.append(comment.getBody());
        this.append(" */");
        return null;
    }

    @Override
    public @Nullable String visitCompleteClass(@NonNull CompleteClass object) {
        List<@NonNull Class> partialClasses = ClassUtil.nullFree(object.getPartialClasses());
        int size = partialClasses.size();
        if (size > 0) {
            this.append(ToStringVisitor.toString(partialClasses.get(0)));
        } else {
            this.appendName(object);
        }
        this.append("*");
        this.append(size);
        return null;
    }

    @Override
    public @Nullable String visitCompletePackage(@NonNull CompletePackage object) {
        this.appendName(object);
        this.append("*");
        this.append(object.getPartialPackages().size());
        this.append(" : ");
        this.append(object.getURI());
        return null;
    }

    @Override
    public String visitConstraint(@NonNull Constraint constraint) {
        List<Element> constrained = constraint.getConstrainedElements();
        if (!constrained.isEmpty()) {
            EObject elem = constrained.get(0);
            this.append("context ");
            if (elem instanceof Type) {
                this.appendName((NamedElement)elem);
            } else if (elem instanceof Operation) {
                Operation oper = (Operation)elem;
                this.appendOperationSignature(oper);
            } else if (elem instanceof Property) {
                Property prop = (Property)elem;
                this.appendPropertySignature(prop);
            }
            this.append(" ");
        }
        String stereo = PivotUtilInternal.getStereotype(constraint);
        this.append(stereo);
        String name = constraint.getName();
        if (name != null) {
            this.append(" ");
            this.append(name);
        }
        this.append(": ");
        this.safeVisit(constraint.getOwnedSpecification());
        return null;
    }

    @Override
    public @Nullable String visitDetail(@NonNull Detail object) {
        this.appendName(object);
        this.append(" = ");
        boolean first = true;
        for (String value : object.getValues()) {
            if (!first) {
                this.append(", ");
            }
            this.append(value);
            first = false;
        }
        return null;
    }

    @Override
    public String visitElementExtension(@NonNull ElementExtension as) {
        this.appendName(as);
        return null;
    }

    @Override
    public String visitEnumLiteralExp(@NonNull EnumLiteralExp el) {
        this.appendQualifiedName(el.getReferredLiteral());
        return null;
    }

    @Override
    public String visitEnumerationLiteral(@NonNull EnumerationLiteral el) {
        this.appendQualifiedName(el.getOwningEnumeration(), "::", el);
        return null;
    }

    @Override
    public String visitExpressionInOCL(@NonNull ExpressionInOCL expression) {
        OCLExpression bodyExpression = expression.getOwnedBody();
        if (bodyExpression != null) {
            return this.safeVisit(bodyExpression);
        }
        this.append(expression.getBody());
        return null;
    }

    @Override
    public String visitIfExp(@NonNull IfExp ifExp) {
        boolean isElseIf = ifExp.isIsElseIf();
        this.append(isElseIf ? "/*else*/if " : "if ");
        this.safeVisit(ifExp.getOwnedCondition());
        this.append(" then ");
        this.safeVisit(ifExp.getOwnedThen());
        this.append(" else ");
        this.safeVisit(ifExp.getOwnedElse());
        this.append(isElseIf ? " /*else*/endif" : " endif");
        return null;
    }

    @Override
    public @Nullable String visitImport(@NonNull Import object) {
        this.appendName(object);
        this.append(" : ");
        this.appendQualifiedName(object.getImportedNamespace());
        return null;
    }

    @Override
    public String visitIntegerLiteralExp(@NonNull IntegerLiteralExp il) {
        this.append(il.getIntegerSymbol());
        return null;
    }

    @Override
    public String visitInvalidLiteralExp(@NonNull InvalidLiteralExp il) {
        this.append("invalid");
        return null;
    }

    @Override
    public String visitInvalidType(@NonNull InvalidType object) {
        this.appendName(object);
        return null;
    }

    @Override
    public String visitIterateExp(@NonNull IterateExp callExp) {
        this.safeVisit(callExp.getOwnedSource());
        this.append(PivotUtil.getNavigationOperator(callExp.isIsSafe(), true));
        this.appendName(callExp.getReferredIteration());
        this.append("(");
        boolean isFirst = true;
        List<Variable> iterators = callExp.getOwnedIterators();
        int iteratorsSize = iterators.size();
        List<Variable> coIterators = callExp.getOwnedCoIterators();
        int coIteratorsSize = coIterators.size();
        int i = 0;
        while (i < iteratorsSize) {
            Variable coIterator;
            Variable iterator = iterators.get(i);
            Variable variable = coIterator = i < coIteratorsSize ? coIterators.get(i) : null;
            if (!isFirst) {
                this.append(", ");
            }
            this.safeVisit(iterator);
            if (coIterator != null) {
                this.append(" <- ");
                this.safeVisit(coIterator);
            }
            isFirst = false;
            ++i;
        }
        this.append("; ");
        this.safeVisit(callExp.getOwnedResult());
        this.append(" | ");
        this.safeVisit(callExp.getOwnedBody());
        this.append(")");
        return null;
    }

    @Override
    public String visitIteration(@NonNull Iteration iteration) {
        this.appendQualifiedName(iteration.getOwningClass(), ".", iteration);
        this.appendTemplateBindings(iteration.getOwnedBindings(), null);
        this.appendTemplateSignature(iteration.getOwnedSignature());
        this.append("(");
        boolean isFirst = true;
        for (Parameter parameter : iteration.getOwnedIterators()) {
            if (!isFirst) {
                this.append(", ");
            }
            this.appendElementType(parameter);
            isFirst = false;
        }
        isFirst = true;
        for (Parameter accumulator : iteration.getOwnedAccumulators()) {
            if (!isFirst) {
                this.append(", ");
            } else {
                this.append("; ");
            }
            this.appendElementType(accumulator);
            isFirst = false;
        }
        isFirst = true;
        for (Parameter parameter : iteration.getOwnedParameters()) {
            if (!isFirst) {
                this.append(", ");
            } else {
                this.append(" | ");
            }
            this.appendElementType(parameter);
            isFirst = false;
        }
        this.append(") : ");
        this.appendElementType(iteration);
        return null;
    }

    @Override
    public String visitIteratorExp(@NonNull IteratorExp callExp) {
        this.safeVisit(callExp.getOwnedSource());
        this.append(PivotUtil.getNavigationOperator(callExp.isIsSafe(), true));
        this.appendName(callExp.getReferredIteration());
        this.append("(");
        boolean isFirst = true;
        List<Variable> iterators = callExp.getOwnedIterators();
        int iteratorsSize = iterators.size();
        List<Variable> coIterators = callExp.getOwnedCoIterators();
        int coIteratorsSize = coIterators.size();
        int i = 0;
        while (i < iteratorsSize) {
            Variable coIterator;
            Variable iterator = iterators.get(i);
            Variable variable = coIterator = i < coIteratorsSize ? coIterators.get(i) : null;
            if (!isFirst) {
                this.append(", ");
            }
            this.safeVisit(iterator);
            if (coIterator != null) {
                this.append(" <- ");
                this.safeVisit(coIterator);
            }
            isFirst = false;
            ++i;
        }
        this.append(" | ");
        this.safeVisit(callExp.getOwnedBody());
        this.append(")");
        return null;
    }

    @Override
    public String visitLambdaType(@NonNull LambdaType lambda) {
        this.appendName(lambda);
        Type contextType = lambda.getContextType();
        if (contextType != null) {
            this.append(" ");
            this.appendType(contextType);
            this.appendTemplateSignature(lambda.getOwnedSignature());
            this.append("(");
            boolean isFirst = true;
            for (Type parameterType : lambda.getParameterType()) {
                if (!isFirst) {
                    this.append(",");
                }
                this.appendType(parameterType);
                isFirst = false;
            }
            this.append(") : ");
            this.appendType(lambda.getResultType());
        }
        return null;
    }

    @Override
    public String visitLetExp(@NonNull LetExp letExp) {
        this.append("let ");
        this.safeVisit(letExp.getOwnedVariable());
        this.append(" in ");
        this.safeVisit(letExp.getOwnedIn());
        return null;
    }

    @Override
    public String visitMapLiteralExp(@NonNull MapLiteralExp mapLiteralExp) {
        this.append("Map{");
        boolean isFirst = true;
        for (MapLiteralPart part : mapLiteralExp.getOwnedParts()) {
            if (!isFirst) {
                this.append(", ");
            }
            this.safeVisit(part);
            isFirst = false;
        }
        this.append("}");
        return null;
    }

    @Override
    public String visitMapLiteralPart(@NonNull MapLiteralPart mapLiteralPart) {
        this.safeVisit(mapLiteralPart.getOwnedKey());
        this.append(" <- ");
        this.safeVisit(mapLiteralPart.getOwnedValue());
        return null;
    }

    @Override
    public String visitMapType(@NonNull MapType object) {
        this.appendName(object);
        List templateBindings = object.getOwnedBindings();
        if (templateBindings.size() > 0) {
            this.append("(");
            String prefix = "";
            int index = 0;
            for (TemplateBinding templateBinding : templateBindings) {
                for (TemplateParameterSubstitution templateParameterSubstitution : templateBinding.getOwnedSubstitutions()) {
                    this.append(prefix);
                    this.safeVisit(templateParameterSubstitution.getActual());
                    if (index == 0 && !object.isKeysAreNullFree() || index == 1 && !object.isValuesAreNullFree()) {
                        this.append("[?]");
                    } else {
                        this.append("[1]");
                    }
                    prefix = ",";
                    ++index;
                }
            }
            this.append(")");
        }
        this.appendTemplateSignature(object.getOwnedSignature());
        return null;
    }

    @Override
    public String visitMessageExp(@NonNull MessageExp messageExp) {
        this.safeVisit(messageExp.getOwnedTarget());
        this.append(messageExp.getType() instanceof CollectionType ? "^^" : "^");
        if (messageExp.getOwnedCalledOperation() != null) {
            this.appendName(messageExp.getOwnedCalledOperation().getOperation());
        } else if (messageExp.getOwnedSentSignal() != null) {
            this.appendName(messageExp.getOwnedSentSignal().getSignal());
        }
        this.append("(");
        String prefix = "";
        for (OCLExpression argument : messageExp.getOwnedArguments()) {
            this.append(prefix);
            this.safeVisit(argument);
            prefix = ", ";
        }
        this.append(")");
        return null;
    }

    @Override
    public String visitModel(@NonNull Model root) {
        this.append(root.getExternalURI());
        return null;
    }

    @Override
    public String visitNullLiteralExp(@NonNull NullLiteralExp il) {
        this.append("null");
        return null;
    }

    @Override
    public String visitOperation(@NonNull Operation operation) {
        this.appendQualifiedName(operation.getOwningClass(), "::", operation);
        this.appendTemplateBindings(operation.getOwnedBindings(), null);
        this.appendTemplateSignature(operation.getOwnedSignature());
        this.append("(");
        boolean isFirst = true;
        for (Parameter parameter : operation.getOwnedParameters()) {
            if (!isFirst) {
                this.append(",");
            }
            this.appendElementType(parameter);
            isFirst = false;
        }
        this.append(") : ");
        this.appendElementType(operation);
        return null;
    }

    @Override
    public String visitOperationCallExp(@NonNull OperationCallExp oc) {
        OCLExpression source = oc.getOwnedSource();
        this.safeVisit(source);
        Operation oper = oc.getReferredOperation();
        if (oper != null) {
            Type sourceType = source != null ? source.getType() : null;
            this.append(PivotUtil.getNavigationOperator(oc.isIsSafe(), PivotUtil.isAggregate(sourceType)));
            this.appendName(oper);
        } else {
            this.append(PivotUtil.getNavigationOperator(false, false));
            this.appendName(oc);
        }
        this.append("(");
        String prefix = "";
        for (OCLExpression argument : oc.getOwnedArguments()) {
            this.append(prefix);
            this.safeVisit(argument);
            prefix = ", ";
        }
        this.append(")");
        this.appendAtPre(oc);
        return null;
    }

    @Override
    public String visitOppositePropertyCallExp(@NonNull OppositePropertyCallExp pc) {
        Property referredOppositeProperty = pc.getReferredProperty();
        Property referredProperty = referredOppositeProperty != null ? referredOppositeProperty.getOpposite() : null;
        this.appendPropertyCallExp(pc, referredProperty);
        return null;
    }

    @Override
    public String visitPackage(@NonNull Package pkg) {
        this.appendQualifiedName(pkg.getOwningPackage(), "::", pkg);
        return null;
    }

    @Override
    public String visitParameter(@NonNull Parameter parameter) {
        this.appendQualifiedName((NamedElement)parameter.eContainer(), ".", parameter);
        return null;
    }

    @Override
    public String visitPrecedence(@NonNull Precedence precedence) {
        PivotMetamodelManager metamodelManager;
        this.appendName(precedence);
        Resource asResource = precedence.eResource();
        if (asResource != null && (metamodelManager = PivotUtilInternal.findMetamodelManager(asResource)) != null) {
            this.append("(" + metamodelManager.getPrecedenceManager().getOrder(precedence) + ")");
        }
        return null;
    }

    @Override
    public String visitPrimitiveType(@NonNull PrimitiveType object) {
        this.appendName(object);
        return null;
    }

    @Override
    public String visitProfileApplication(@NonNull ProfileApplication object) {
        this.appendQualifiedName(object.getAppliedProfile());
        this.append(" applied-to ");
        this.appendQualifiedName(object.getOwningPackage());
        return null;
    }

    @Override
    public String visitProperty(@NonNull Property property) {
        this.appendQualifiedName(property.getOwningClass(), "::", property);
        return null;
    }

    @Override
    public String visitPropertyCallExp(@NonNull PropertyCallExp pc) {
        Property property = pc.getReferredProperty();
        this.appendPropertyCallExp(pc, property);
        return null;
    }

    @Override
    public String visitRealLiteralExp(@NonNull RealLiteralExp rl) {
        this.append(rl.getRealSymbol());
        return null;
    }

    @Override
    public String visitShadowExp(@NonNull ShadowExp shadowExp) {
        this.appendQualifiedName(shadowExp.getType());
        this.append("{");
        String prefix = "";
        for (ShadowPart part : shadowExp.getOwnedParts()) {
            this.append(prefix);
            this.safeVisit(part);
            prefix = ", ";
        }
        this.append("}");
        return null;
    }

    @Override
    public String visitShadowPart(@NonNull ShadowPart part) {
        this.appendName(part.getReferredProperty());
        OCLExpression initExpression = part.getOwnedInit();
        if (initExpression != null) {
            this.append(" = ");
            this.safeVisit(initExpression);
        }
        return null;
    }

    @Override
    public String visitStateExp(@NonNull StateExp s) {
        this.appendName(s);
        return null;
    }

    @Override
    public String visitStereotypeExtender(@NonNull StereotypeExtender object) {
        this.appendQualifiedName(object.getClass_());
        this.append(" extended-by ");
        this.appendQualifiedName(object.getOwningStereotype());
        return null;
    }

    @Override
    public String visitStringLiteralExp(@NonNull StringLiteralExp sl) {
        this.append("'");
        this.append(sl.getStringSymbol());
        this.append("'");
        return null;
    }

    @Override
    public String visitTemplateBinding(@NonNull TemplateBinding object) {
        this.appendTemplateBindings(Collections.singletonList(object), null);
        return null;
    }

    @Override
    public String visitTemplateParameter(@NonNull TemplateParameter object) {
        TemplateSignature signature = object.getOwningSignature();
        this.appendName(signature != null ? (NamedElement)((Object)signature.getOwningElement()) : null);
        this.append(".");
        this.appendName(object);
        return null;
    }

    @Override
    public String visitTemplateParameterSubstitution(@NonNull TemplateParameterSubstitution object) {
        TemplateParameter formal = object.getFormal();
        this.appendName(formal != null ? formal : null);
        this.append("/");
        this.safeVisit(object.getActual());
        return null;
    }

    @Override
    public String visitTemplateSignature(@NonNull TemplateSignature object) {
        this.appendTemplateSignature(object);
        return null;
    }

    @Override
    public String visitTupleLiteralExp(@NonNull TupleLiteralExp literalExp) {
        this.append("Tuple{");
        String prefix = "";
        for (TupleLiteralPart part : literalExp.getOwnedParts()) {
            this.append(prefix);
            this.safeVisit(part);
            prefix = ", ";
        }
        this.append("}");
        return null;
    }

    @Override
    public String visitTupleLiteralPart(@NonNull TupleLiteralPart part) {
        OCLExpression initExpression;
        this.appendName(part);
        Type type = part.getType();
        if (type != null) {
            this.append(" : ");
            this.appendElementType(part);
        }
        if ((initExpression = part.getOwnedInit()) != null) {
            this.append(" = ");
            this.safeVisit(initExpression);
        }
        return null;
    }

    @Override
    public String visitTupleType(@NonNull TupleType object) {
        this.appendName(object);
        this.append("(");
        String prefix = "";
        for (TypedElement typedElement : object.getOwnedProperties()) {
            this.append(prefix);
            this.appendName(typedElement);
            this.append(":");
            this.appendElementType(typedElement);
            prefix = ",";
        }
        this.append(")");
        return null;
    }

    @Override
    public String visitTypeExp(@NonNull TypeExp t) {
        this.safeVisit(t.getReferredType());
        return null;
    }

    @Override
    public String visitUnlimitedNaturalLiteralExp(@NonNull UnlimitedNaturalLiteralExp unl) {
        this.append(unl.getUnlimitedNaturalSymbol());
        return null;
    }

    @Override
    public String visitWildcardType(@NonNull WildcardType object) {
        this.appendName(object);
        return null;
    }

    @Override
    public String visitUnspecifiedValueExp(@NonNull UnspecifiedValueExp uv) {
        this.append("?");
        if (uv.getType() != null && !(uv.getType() instanceof VoidType)) {
            this.append(" : ");
            this.appendName(uv.getType());
        }
        return null;
    }

    @Override
    public String visitVariable(@NonNull Variable variable) {
        OCLExpression initExpression;
        this.appendName(variable);
        Type type = variable.getType();
        if (type != null) {
            this.append(" : ");
            this.appendElementType(variable);
        }
        if ((initExpression = variable.getOwnedInit()) != null) {
            this.append(" = ");
            this.safeVisit(initExpression);
        }
        return null;
    }

    @Override
    public String visitVariableExp(@NonNull VariableExp v) {
        this.appendName(v.getReferredVariable());
        return null;
    }

    @Override
    public String visitVoidType(@NonNull VoidType object) {
        this.appendName(object);
        return null;
    }

    @Override
    public String visiting(@NonNull Visitable visitable) {
        this.append(visitable.getClass().getName());
        return null;
    }

    protected static class AS2StringFactory
    implements Factory {
        protected AS2StringFactory() {
            ToStringVisitor.addFactory(this);
        }

        @Override
        public @NonNull ToStringVisitor createToStringVisitor(@NonNull StringBuilder s) {
            return new ToStringVisitor(s);
        }

        @Override
        public @NonNull EPackage getEPackage() {
            PivotPackage eInstance = PivotPackage.eINSTANCE;
            assert (eInstance != null);
            return eInstance;
        }
    }

    public static interface Factory {
        public @NonNull ToStringVisitor createToStringVisitor(@NonNull StringBuilder var1);

        public @NonNull EPackage getEPackage();
    }
}

