/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.utilities;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.impl.EValidatorRegistryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactory;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactoryRegistry;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.internal.utilities.Technology;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.validation.ComposedEValidator;

public abstract class PivotDiagnostician
extends Diagnostician {
    private static Boolean diagnosticianHasDoValidate = null;
    protected final AdapterFactory adapterFactory;
    protected final @NonNull Technology technology;

    public static @NonNull Diagnostician createDiagnostician(@NonNull ResourceSet resourceSet, AdapterFactory adapterFactory, @Nullable IProgressMonitor progressMonitor) {
        return PivotDiagnostician.createDiagnostician(resourceSet, null, adapterFactory, progressMonitor);
    }

    public static @NonNull Diagnostician createDiagnostician(@NonNull ResourceSet resourceSet, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable EValidator.Registry globalEValidatorRegistry, AdapterFactory adapterFactory, @Nullable IProgressMonitor progressMonitor) {
        EValidatorRegistryImpl localEValidatorRegistry = new EValidatorRegistryImpl();
        for (ASResourceFactory asResourceFactory : ASResourceFactoryRegistry.INSTANCE.getExternalResourceFactories()) {
            asResourceFactory.initializeEValidatorRegistry((EValidator.Registry)localEValidatorRegistry);
        }
        if (globalEValidatorRegistry != null) {
            ArrayList stableKeySet = new ArrayList(globalEValidatorRegistry.keySet());
            for (EPackage ePackage : stableKeySet) {
                if (ePackage == null) continue;
                Object localEValidator = localEValidatorRegistry.get((Object)ePackage);
                Object globalEValidator = globalEValidatorRegistry.get((Object)ePackage);
                if (localEValidator == null) {
                    if (globalEValidator == null) continue;
                    localEValidatorRegistry.put((Object)ePackage, globalEValidator);
                    continue;
                }
                if (globalEValidator == null) continue;
                ComposedEValidator composedEValidator = null;
                if (localEValidator instanceof ComposedEValidator) {
                    composedEValidator = (ComposedEValidator)localEValidator;
                } else if (localEValidator instanceof EValidator.Descriptor) {
                    composedEValidator = new ComposedEValidator(((EValidator.Descriptor)localEValidator).getEValidator());
                    localEValidatorRegistry.put((Object)ePackage, (Object)composedEValidator);
                } else if (localEValidator instanceof EValidator) {
                    composedEValidator = new ComposedEValidator((EValidator)localEValidator);
                    localEValidatorRegistry.put((Object)ePackage, (Object)composedEValidator);
                }
                if (composedEValidator == null) continue;
                if (globalEValidator instanceof EValidator.Descriptor) {
                    composedEValidator.addChild(((EValidator.Descriptor)globalEValidator).getEValidator());
                    continue;
                }
                if (!(globalEValidator instanceof EValidator)) continue;
                composedEValidator.addChild((EValidator)globalEValidator);
            }
        }
        if (diagnosticianHasDoValidate == null) {
            diagnosticianHasDoValidate = false;
            Method[] methodArray = Diagnostician.class.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if ("doValidate".equals(method.getName())) {
                    diagnosticianHasDoValidate = true;
                }
                ++n2;
            }
        }
        if (diagnosticianHasDoValidate.booleanValue()) {
            return new Diagnostician_2_9((EValidator.Registry)localEValidatorRegistry, resourceSet, adapterFactory, (IProgressMonitor)(progressMonitor != null ? progressMonitor : new NullProgressMonitor()));
        }
        return new Diagnostician_2_8((EValidator.Registry)localEValidatorRegistry, resourceSet, adapterFactory);
    }

    @Deprecated
    public static @NonNull OCL getOCL(@NonNull Map<Object, Object> context) {
        return PivotDiagnostician.getOCL(context, null);
    }

    public static @NonNull OCL getOCL(@NonNull Map<Object, Object> context, @Nullable EObject eObject) {
        OCL ocl = null;
        Object oclRef = context.get(WeakOCLReference.class);
        if (oclRef instanceof WeakOCLReference) {
            ocl = (OCL)((WeakOCLReference)oclRef).get();
        }
        if (ocl == null) {
            EnvironmentFactoryInternal environmentFactory;
            if (eObject != null && (environmentFactory = PivotUtilInternal.findEnvironmentFactory(eObject)) != null) {
                ocl = environmentFactory.createOCL();
            }
            if (ocl == null) {
                ocl = OCL.newInstance();
            }
            context.put(WeakOCLReference.class, new WeakOCLReference(ocl));
        }
        return ocl;
    }

    public static void setOCL(@NonNull Map<Object, Object> context, @NonNull OCL ocl) {
        context.put(WeakOCLReference.class, new WeakOCLReference(ocl));
    }

    protected PivotDiagnostician(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull EValidator.Registry eValidatorRegistry, @NonNull ResourceSet resourceSet, AdapterFactory adapterFactory) {
        super(eValidatorRegistry);
        this.adapterFactory = adapterFactory;
        this.technology = ASResourceFactoryRegistry.INSTANCE.getTechnology();
        OCLDelegateDomain.initializePivotOnlyDiagnosticianResourceSet(resourceSet);
    }

    public Map<Object, Object> createDefaultContext() {
        Map context = super.createDefaultContext();
        if (context != null) {
            OCLDelegateDomain.initializePivotOnlyDiagnosticianContext(context);
        }
        return context;
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (eClass != null && !this.technology.isValidatable(eClass)) {
            return true;
        }
        if (eObject instanceof EAnnotation && "http://www.eclipse.org/uml2/2.0.0/UML".equals(((EAnnotation)eObject).getSource())) {
            return true;
        }
        return super.validate(eClass, eObject, diagnostics, context);
    }

    public static class BasicDiagnosticWithRemove
    extends BasicDiagnostic {
        public static BasicDiagnostic validate(EObject eObject, Map<Object, Object> validationContext) {
            BasicDiagnosticWithRemove diagnostics = new BasicDiagnosticWithRemove("org.eclipse.emf.ecore", 0, EcorePlugin.INSTANCE.getString("_UI_DiagnosticRoot_diagnostic", new Object[]{Diagnostician.INSTANCE.getObjectLabel(eObject)}), new Object[]{eObject});
            Diagnostician.INSTANCE.validate(eObject, (DiagnosticChain)diagnostics, validationContext);
            return diagnostics;
        }

        public BasicDiagnosticWithRemove(String source, int code, String message, Object[] data) {
            super(source, code, message, data);
        }

        public Diagnostic remove(int index) {
            return (Diagnostic)this.children.remove(index);
        }
    }

    protected static final class Diagnostician_2_8
    extends PivotDiagnostician {
        protected Diagnostician_2_8(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull EValidator.Registry eValidatorRegistry, @NonNull ResourceSet resourceSet, AdapterFactory adapterFactory) {
            super(eValidatorRegistry, resourceSet, adapterFactory);
        }

        public String getObjectLabel(EObject eObject) {
            IItemLabelProvider itemLabelProvider;
            if (this.adapterFactory != null && !eObject.eIsProxy() && (itemLabelProvider = (IItemLabelProvider)this.adapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class)) != null) {
                return itemLabelProvider.getText((Object)eObject);
            }
            return super.getObjectLabel(eObject);
        }
    }

    protected static final class Diagnostician_2_9
    extends PivotDiagnostician {
        private final @NonNull ResourceSet resourceSet;
        private final @NonNull IProgressMonitor progressMonitor;

        protected Diagnostician_2_9(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull EValidator.Registry eValidatorRegistry, @NonNull ResourceSet resourceSet, AdapterFactory adapterFactory, @NonNull IProgressMonitor progressMonitor) {
            super(eValidatorRegistry, resourceSet, adapterFactory);
            this.resourceSet = resourceSet;
            this.progressMonitor = progressMonitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean doValidate(EValidator eValidator, EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
            this.progressMonitor.worked(1);
            ResourceSet resourceSet = this.resourceSet;
            synchronized (resourceSet) {
                return super.doValidate(eValidator, eClass, eObject, diagnostics, context);
            }
        }

        public String getObjectLabel(EObject eObject) {
            IItemLabelProvider itemLabelProvider;
            if (this.adapterFactory != null && !eObject.eIsProxy() && (itemLabelProvider = (IItemLabelProvider)this.adapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class)) != null) {
                return itemLabelProvider.getText((Object)eObject);
            }
            return super.getObjectLabel(eObject);
        }
    }

    public static final class WeakOCLReference
    extends WeakReference<OCL> {
        protected final @NonNull OCL ocl;

        protected WeakOCLReference(@NonNull OCL ocl) {
            super(ocl);
            this.ocl = ocl;
        }

        public void finalize() {
            new Thread("OCL-Finalizer"){

                @Override
                public void run() {
                    ocl.dispose();
                }
            }.start();
        }
    }
}

