/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.plugin;

import java.util.HashSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.internal.registry.CompleteOCLRegistry;

public class CompleteOCLRegistryReader
extends RegistryReader {
    private static final @NonNull String TAG_DOCUMENT = "document";
    private static final @NonNull String TAG_FOR = "for";
    private static final @NonNull String ATTRIBUTE_RESOURCE = "resource";
    private static final @NonNull String ATTRIBUTE_URI = "uri";
    protected final @NonNull CompleteOCLRegistry registry;

    public CompleteOCLRegistryReader(@NonNull CompleteOCLRegistry registry) {
        super(Platform.getExtensionRegistry(), "org.eclipse.ocl.pivot", "complete_ocl_registry");
        this.registry = registry;
    }

    protected boolean readElement(IConfigurationElement element, boolean add) {
        String tagName = element.getName();
        if (TAG_FOR.equals(tagName)) {
            return true;
        }
        if (!TAG_DOCUMENT.equals(tagName)) {
            return false;
        }
        String filePath = element.getAttribute(ATTRIBUTE_RESOURCE);
        boolean recognized = true;
        if (filePath == null) {
            this.logMissingAttribute(element, ATTRIBUTE_RESOURCE);
            recognized = false;
        } else {
            HashSet<String> nsURIs = new HashSet<String>();
            IConfigurationElement[] iConfigurationElementArray = element.getChildren(TAG_FOR);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement childElement = iConfigurationElementArray[n2];
                String nsURI = childElement.getAttribute(ATTRIBUTE_URI);
                if (nsURI == null) {
                    this.logMissingAttribute(childElement, ATTRIBUTE_URI);
                    recognized = false;
                } else {
                    nsURIs.add(nsURI);
                }
                ++n2;
            }
            URI declaredURI = URI.createURI((String)filePath);
            String bundleName = "/" + element.getDeclaringExtension().getContributor().getName() + "/";
            URI bundleURI = URI.createPlatformPluginURI((String)bundleName, (boolean)true);
            @NonNull URI resourceURI = declaredURI.resolve(bundleURI);
            CompleteOCLRegistry.Registration registration = new CompleteOCLRegistry.Registration(resourceURI, nsURIs);
            if (add) {
                this.registry.addRegistration(registration);
            } else {
                this.registry.removeRegistration(registration);
            }
        }
        return recognized;
    }
}

