/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.properties.tabbed.view;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.views.properties.tabbed.l10n.TabbedPropertyMessages;
import org.eclipse.ui.internal.views.properties.tabbed.view.OverridableTabListContentProvider;
import org.eclipse.ui.internal.views.properties.tabbed.view.SectionDescriptor;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabDescriptor;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabListContentProvider;
import org.eclipse.ui.views.properties.tabbed.AbstractTabDescriptor;
import org.eclipse.ui.views.properties.tabbed.IActionProvider;
import org.eclipse.ui.views.properties.tabbed.ISectionDescriptor;
import org.eclipse.ui.views.properties.tabbed.ISectionDescriptorProvider;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptorProvider;
import org.eclipse.ui.views.properties.tabbed.ITypeMapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class TabbedPropertyRegistry {
    private static final String NO_TAB_ERROR = TabbedPropertyMessages.TabbedPropertyRegistry_Non_existing_tab;
    private static final String CONTRIBUTOR_ERROR = TabbedPropertyMessages.TabbedPropertyRegistry_contributor_error;
    private static final String TAB_ERROR = TabbedPropertyMessages.TabDescriptor_Tab_unknown_category;
    private static final String EXTPT_CONTRIBUTOR = "propertyContributor";
    private static final String EXTPT_TABS = "propertyTabs";
    private static final String EXTPT_SECTIONS = "propertySections";
    private static final String ELEMENT_TAB = "propertyTab";
    private static final String ELEMENT_SECTION = "propertySection";
    private static final String ELEMENT_PROPERTY_CATEGORY = "propertyCategory";
    private static final String ATT_CATEGORY = "category";
    private static final String ATT_CONTRIBUTOR_ID = "contributorId";
    private static final String ATT_TYPE_MAPPER = "typeMapper";
    private static final String ATT_LABEL_PROVIDER = "labelProvider";
    private static final String ATT_ACTION_PROVIDER = "actionProvider";
    private static final String ATT_SECTION_DESCRIPTOR_PROVIDER = "sectionDescriptorProvider";
    private static final String ATT_TAB_DESCRIPTOR_PROVIDER = "tabDescriptorProvider";
    private static final String ATT_OVERRIDABLE_TAB_LIST_CONTENT_PROVIDER = "overridableTabListContentProvider";
    private static final String TOP = "top";
    protected String contributorId;
    protected IConfigurationElement contributorConfigurationElement;
    protected List<String> propertyCategories;
    protected ILabelProvider labelProvider;
    protected IActionProvider actionProvider;
    protected ITypeMapper typeMapper;
    protected ISectionDescriptorProvider sectionDescriptorProvider;
    protected ITabDescriptorProvider tabDescriptorProvider;
    protected ITabDescriptor[] tabDescriptors;
    protected static final AbstractTabDescriptor[] EMPTY_DESCRIPTOR_ARRAY = new TabDescriptor[0];
    protected boolean overridableTabListContentProvider = false;

    protected TabbedPropertyRegistry(String id) {
        IConfigurationElement[] extensions;
        this.contributorId = id;
        this.propertyCategories = new ArrayList<String>();
        IConfigurationElement[] iConfigurationElementArray = extensions = this.getConfigurationElements(EXTPT_CONTRIBUTOR);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String contributor = configurationElement.getAttribute(ATT_CONTRIBUTOR_ID);
            if (contributor != null && id.equals(contributor)) {
                this.contributorConfigurationElement = configurationElement;
                try {
                    if (configurationElement.getAttribute(ATT_LABEL_PROVIDER) != null) {
                        this.labelProvider = (ILabelProvider)configurationElement.createExecutableExtension(ATT_LABEL_PROVIDER);
                    }
                    if (configurationElement.getAttribute(ATT_ACTION_PROVIDER) != null) {
                        this.actionProvider = (IActionProvider)configurationElement.createExecutableExtension(ATT_ACTION_PROVIDER);
                    }
                    if (configurationElement.getAttribute(ATT_TYPE_MAPPER) != null) {
                        this.typeMapper = (ITypeMapper)configurationElement.createExecutableExtension(ATT_TYPE_MAPPER);
                    }
                    if (configurationElement.getAttribute(ATT_SECTION_DESCRIPTOR_PROVIDER) != null) {
                        this.sectionDescriptorProvider = (ISectionDescriptorProvider)configurationElement.createExecutableExtension(ATT_SECTION_DESCRIPTOR_PROVIDER);
                    }
                    if (configurationElement.getAttribute(ATT_TAB_DESCRIPTOR_PROVIDER) != null) {
                        this.tabDescriptorProvider = (ITabDescriptorProvider)configurationElement.createExecutableExtension(ATT_TAB_DESCRIPTOR_PROVIDER);
                    }
                    if (configurationElement.getAttribute(ATT_OVERRIDABLE_TAB_LIST_CONTENT_PROVIDER) != null) {
                        String attributeBoolean = configurationElement.getAttribute(ATT_OVERRIDABLE_TAB_LIST_CONTENT_PROVIDER);
                        this.overridableTabListContentProvider = attributeBoolean.equals("true");
                    }
                }
                catch (CoreException exception) {
                    this.handleConfigurationError(id, exception);
                }
                this.addPropertyCategories(configurationElement);
            }
            ++n2;
        }
        if (this.propertyCategories == null || this.contributorId == null || this.contributorConfigurationElement == null) {
            this.handleConfigurationError(id, null);
            this.contributorId = null;
        }
    }

    private void addPropertyCategories(IConfigurationElement configurationElement) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = configurationElement.getChildren(ELEMENT_PROPERTY_CATEGORY);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            this.propertyCategories.add(element.getAttribute(ATT_CATEGORY));
            ++n2;
        }
    }

    private void handleConfigurationError(String id, CoreException exception) {
        String message = MessageFormat.format((String)CONTRIBUTOR_ERROR, (Object[])new Object[]{id});
        Bundle bundle = FrameworkUtil.getBundle(TabbedPropertyRegistry.class);
        Status status = new Status(4, bundle.getSymbolicName(), 4, message, (Throwable)exception);
        Platform.getLog((Bundle)bundle).log((IStatus)status);
    }

    protected ISectionDescriptor[] readSectionDescriptors() {
        IConfigurationElement[] extensions;
        ArrayList<SectionDescriptor> result = new ArrayList<SectionDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = extensions = this.getConfigurationElements(EXTPT_SECTIONS);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] sections;
            IConfigurationElement extension = iConfigurationElementArray[n2];
            IConfigurationElement[] iConfigurationElementArray2 = sections = extension.getChildren(ELEMENT_SECTION);
            int n3 = sections.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement section = iConfigurationElementArray2[n4];
                SectionDescriptor descriptor = new SectionDescriptor(section, this.typeMapper);
                result.add(descriptor);
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new ISectionDescriptor[result.size()]);
    }

    protected IConfigurationElement[] getConfigurationElements(String extensionPointId) {
        if (this.contributorId == null) {
            return new IConfigurationElement[0];
        }
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(FrameworkUtil.getBundle(TabbedPropertyRegistry.class).getSymbolicName(), extensionPointId);
        IConfigurationElement[] extensions = point.getConfigurationElements();
        ArrayList<IConfigurationElement> unordered = new ArrayList<IConfigurationElement>(extensions.length);
        IConfigurationElement[] iConfigurationElementArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String contributor;
            IConfigurationElement extension = iConfigurationElementArray[n2];
            if (extension.getName().equals(extensionPointId) && this.contributorId.equals(contributor = extension.getAttribute(ATT_CONTRIBUTOR_ID))) {
                unordered.add(extension);
            }
            ++n2;
        }
        return unordered.toArray(new IConfigurationElement[unordered.size()]);
    }

    private int getIndex(Object[] array, Object target) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(target)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public ITabDescriptor[] getTabDescriptors(IWorkbenchPart part, ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            return EMPTY_DESCRIPTOR_ARRAY;
        }
        ITabDescriptor[] allDescriptors = null;
        allDescriptors = this.tabDescriptorProvider == null ? this.getAllTabDescriptors() : this.tabDescriptorProvider.getTabDescriptors(part, selection);
        ITabDescriptor[] result = this.filterTabDescriptors(allDescriptors, part, selection);
        return result;
    }

    protected ITabDescriptor[] filterTabDescriptors(ITabDescriptor[] descriptors, IWorkbenchPart part, ISelection selection) {
        ArrayList<ITabDescriptor> result = new ArrayList<ITabDescriptor>();
        ITabDescriptor[] iTabDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            ITabDescriptor descriptor = iTabDescriptorArray[n2];
            ITabDescriptor filteredDescriptor = this.adaptDescriptorFor(descriptor, part, selection);
            if (!filteredDescriptor.getSectionDescriptors().isEmpty()) {
                result.add(filteredDescriptor);
            }
            ++n2;
        }
        if (result.isEmpty()) {
            return EMPTY_DESCRIPTOR_ARRAY;
        }
        return result.toArray(new ITabDescriptor[result.size()]);
    }

    protected ITabDescriptor adaptDescriptorFor(ITabDescriptor target, IWorkbenchPart part, ISelection selection) {
        ArrayList<ISectionDescriptor> filteredSectionDescriptors = new ArrayList<ISectionDescriptor>();
        List descriptors = target.getSectionDescriptors();
        for (ISectionDescriptor descriptor : descriptors) {
            if (!descriptor.appliesTo(part, selection)) continue;
            filteredSectionDescriptors.add(descriptor);
        }
        AbstractTabDescriptor result = (AbstractTabDescriptor)((AbstractTabDescriptor)target).clone();
        result.setSectionDescriptors(filteredSectionDescriptors);
        return result;
    }

    protected ITabDescriptor[] getAllTabDescriptors() {
        if (this.tabDescriptors == null) {
            List<TabDescriptor> temp = this.readTabDescriptors();
            this.populateWithSectionDescriptors(temp);
            temp = this.sortTabDescriptorsByCategory(temp);
            temp = this.sortTabDescriptorsByAfterTab(temp);
            this.tabDescriptors = temp.toArray(new TabDescriptor[temp.size()]);
        }
        return this.tabDescriptors;
    }

    protected List readTabDescriptors() {
        IConfigurationElement[] extensions;
        ArrayList<TabDescriptor> result = new ArrayList<TabDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = extensions = this.getConfigurationElements(EXTPT_TABS);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] tabs;
            IConfigurationElement extension = iConfigurationElementArray[n2];
            IConfigurationElement[] iConfigurationElementArray2 = tabs = extension.getChildren(ELEMENT_TAB);
            int n3 = tabs.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement tab = iConfigurationElementArray2[n4];
                TabDescriptor descriptor = new TabDescriptor(tab);
                if (this.getIndex(this.propertyCategories.toArray(), descriptor.getCategory()) == -1) {
                    this.handleTabError(tab, descriptor.getCategory() == null ? "" : descriptor.getCategory());
                } else {
                    result.add(descriptor);
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    protected void populateWithSectionDescriptors(List aTabDescriptors) {
        ISectionDescriptor[] sections = null;
        sections = this.sectionDescriptorProvider != null ? this.sectionDescriptorProvider.getSectionDescriptors() : this.readSectionDescriptors();
        ISectionDescriptor[] iSectionDescriptorArray = sections;
        int n = sections.length;
        int n2 = 0;
        while (n2 < n) {
            ISectionDescriptor section = iSectionDescriptorArray[n2];
            this.appendToTabDescriptor(section, aTabDescriptors);
            ++n2;
        }
    }

    protected void appendToTabDescriptor(ISectionDescriptor section, List aTabDescriptors) {
        for (TabDescriptor tab : aTabDescriptors) {
            if (!tab.append(section)) continue;
            return;
        }
        String message = MessageFormat.format((String)NO_TAB_ERROR, (Object[])new Object[]{section.getId(), section.getTargetTab()});
        Bundle bundle = FrameworkUtil.getBundle(TabbedPropertyRegistry.class);
        Status status = new Status(4, bundle.getSymbolicName(), 1, message, null);
        Platform.getLog((Bundle)bundle).log((IStatus)status);
    }

    protected List<TabDescriptor> sortTabDescriptorsByCategory(List<TabDescriptor> descriptors) {
        Collections.sort(descriptors, (one, two) -> {
            String categoryOne = one.getCategory();
            String categoryTwo = two.getCategory();
            int categoryOnePosition = this.getIndex(this.propertyCategories.toArray(), categoryOne);
            int categoryTwoPosition = this.getIndex(this.propertyCategories.toArray(), categoryTwo);
            return categoryOnePosition - categoryTwoPosition;
        });
        return descriptors;
    }

    protected List<TabDescriptor> sortTabDescriptorsByAfterTab(List<TabDescriptor> tabs) {
        if (tabs.isEmpty() || this.propertyCategories == null) {
            return tabs;
        }
        ArrayList<TabDescriptor> sorted = new ArrayList<TabDescriptor>();
        int categoryIndex = 0;
        int i = 0;
        while (i < this.propertyCategories.size()) {
            ArrayList<TabDescriptor> categoryList = new ArrayList<TabDescriptor>();
            String category = this.propertyCategories.get(i);
            int topOfCategory = categoryIndex;
            int endOfCategory = categoryIndex;
            while (endOfCategory < tabs.size() && tabs.get(endOfCategory).getCategory().equals(category)) {
                ++endOfCategory;
            }
            int j = topOfCategory;
            while (j < endOfCategory) {
                TabDescriptor tab = tabs.get(j);
                if (tab.getAfterTab().equals(TOP)) {
                    categoryList.add(0, tabs.get(j));
                } else {
                    categoryList.add(tabs.get(j));
                }
                ++j;
            }
            Collections.sort(categoryList, (one, two) -> {
                if (two.getAfterTab().equals(one.getId())) {
                    return -1;
                }
                if (one.getAfterTab().equals(two.getId())) {
                    return 1;
                }
                return 0;
            });
            j = 0;
            while (j < categoryList.size()) {
                sorted.add((TabDescriptor)categoryList.get(j));
                ++j;
            }
            categoryIndex = endOfCategory;
            ++i;
        }
        return sorted;
    }

    public ITypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public IActionProvider getActionProvider() {
        return this.actionProvider;
    }

    public IStructuredContentProvider getTabListContentProvider() {
        if (this.overridableTabListContentProvider) {
            return new OverridableTabListContentProvider(this);
        }
        return new TabListContentProvider(this);
    }

    private void handleTabError(IConfigurationElement configurationElement, String category) {
        String pluginId = configurationElement.getDeclaringExtension().getContributor().getName();
        String message = MessageFormat.format((String)TAB_ERROR, (Object[])new Object[]{pluginId, category});
        Status status = new Status(4, pluginId, 3, message, null);
        Bundle bundle = FrameworkUtil.getBundle(TabbedPropertyRegistry.class);
        Platform.getLog((Bundle)bundle).log((IStatus)status);
    }

    public void dispose() {
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
            this.labelProvider = null;
        }
        if (this.tabDescriptors != null) {
            ITabDescriptor[] iTabDescriptorArray = this.tabDescriptors;
            int n = this.tabDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                ITabDescriptor tabDescriptor = iTabDescriptorArray[n2];
                if (tabDescriptor instanceof TabDescriptor) {
                    ((TabDescriptor)tabDescriptor).dispose();
                }
                ++n2;
            }
        }
    }
}

