/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.util;

import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.parsers.OpaqueBehaviorViewUtil;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.ChangeEvent;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.TimeEvent;
import org.eclipse.uml2.uml.TimeExpression;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.ValueSpecification;

public class TriggerUtil {
    public static String getTextForTrigger(View view, Trigger trigger) {
        StringBuilder result = new StringBuilder();
        if (trigger != null) {
            Event e = trigger.getEvent();
            if (e instanceof CallEvent) {
                Operation op = ((CallEvent)e).getOperation();
                if (op != null) {
                    result.append(UMLLabelInternationalization.getInstance().getLabel((NamedElement)op));
                    if (op.getOwnedParameters().size() > 0 && OpaqueBehaviorViewUtil.displayParamDots(view)) {
                        result.append("(...)");
                    }
                } else {
                    result.append(UMLLabelInternationalization.getInstance().getLabel((NamedElement)e));
                }
            } else if (e instanceof SignalEvent) {
                Signal signal = ((SignalEvent)e).getSignal();
                if (signal != null) {
                    result.append(UMLLabelInternationalization.getInstance().getLabel((NamedElement)signal));
                    if (signal.getAttributes().size() > 0 && OpaqueBehaviorViewUtil.displayParamDots(view)) {
                        result.append("(...)");
                    }
                } else {
                    result.append(UMLLabelInternationalization.getInstance().getLabel((NamedElement)e));
                }
            } else if (e instanceof ChangeEvent) {
                ValueSpecification vs = ((ChangeEvent)e).getChangeExpression();
                String value = vs instanceof OpaqueExpression ? OpaqueBehaviorViewUtil.retrieveBody(view, (OpaqueExpression)vs) : vs.stringValue();
                result.append(value);
            } else if (e instanceof TimeEvent) {
                ValueSpecification vs;
                TimeEvent timeEvent = (TimeEvent)e;
                result.append(timeEvent.isRelative() ? "after " : "at ");
                TimeExpression te = timeEvent.getWhen();
                String value = te != null ? ((vs = te.getExpr()) instanceof OpaqueExpression ? OpaqueBehaviorViewUtil.retrieveBody(view, (OpaqueExpression)vs) : vs.stringValue()) : "undefined";
                result.append(value);
            } else {
                result.append("all");
            }
        }
        return result.toString();
    }
}

