/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.hyperlink.ui;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.papyrus.commands.CreationCommandDescriptor;
import org.eclipse.papyrus.commands.CreationCommandRegistry;
import org.eclipse.papyrus.commands.ICreationCommand;
import org.eclipse.papyrus.commands.ICreationCommandRegistry;
import org.eclipse.papyrus.infra.core.extension.NotFoundException;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.hyperlink.Activator;
import org.eclipse.papyrus.infra.hyperlink.ui.AbstractLookForEditorShell;
import org.eclipse.papyrus.infra.hyperlink.util.EditorListContentProvider;
import org.eclipse.papyrus.infra.hyperlink.util.TreeViewContentProvider;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.ui.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFGraphicalContentProvider;
import org.eclipse.papyrus.infra.ui.emf.providers.strategy.ContainmentBrowseStrategy;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class EditorLookForEditorShell
extends AbstractLookForEditorShell {
    protected AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    protected Object selectedEditor;
    protected EObject model;
    protected Menu diagramMenuButton;
    protected TreeViewer diagramListTreeViewer;
    protected TreeViewer treeViewer;

    protected Object getSelectedEditor() {
        return this.selectedEditor;
    }

    protected void setSelectedEditor(Object selectedEditor) {
        this.selectedEditor = selectedEditor;
    }

    public EditorLookForEditorShell(Shell parentShell, IPageIconsRegistry editorFactoryRegistry, EObject amodel) {
        super(parentShell);
        this.model = amodel;
    }

    public EditorLookForEditorShell(IShellProvider parentShell, IPageIconsRegistry editorFactoryRegistry, EObject amodel) {
        super(parentShell);
        this.model = amodel;
    }

    protected void contentsCreated() {
        LabelProvider labelProvider;
        this.treeViewer = this.getModeFilteredTree().getViewer();
        this.treeViewer.setUseHashlookup(true);
        ServicesRegistry registry = null;
        try {
            registry = ServiceUtilsForEObject.getInstance().getServiceRegistry(this.model);
            labelProvider = ((LabelProviderService)registry.getService(LabelProviderService.class)).getLabelProvider();
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            labelProvider = new LabelProvider();
        }
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        TreeViewContentProvider semanticProvider = new TreeViewContentProvider(new EObject[]{EcoreUtil.getRootContainer((EObject)this.model)});
        ContainmentBrowseStrategy strategy = new ContainmentBrowseStrategy((ITreeContentProvider)semanticProvider);
        EMFGraphicalContentProvider graphicalContentProvider = new EMFGraphicalContentProvider((IStructuredContentProvider)strategy, this.model.eResource().getResourceSet(), "org.eclipse.papyrus.infra.hyperlink.editorTreeView");
        this.treeViewer.setContentProvider((IContentProvider)graphicalContentProvider);
        this.treeViewer.setInput((Object)registry);
        graphicalContentProvider.createAfter(this.getAfterTreeViewComposite());
        this.diagramListTreeViewer = this.getDiagramfilteredTree().getViewer();
        this.diagramListTreeViewer.setUseHashlookup(true);
        this.diagramListTreeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.diagramListTreeViewer.setContentProvider((IContentProvider)new EditorListContentProvider(this.model));
        this.diagramListTreeViewer.setInput((Object)"");
        this.diagramMenuButton = new Menu((Control)this.getNewDiagrambutton());
        this.getNewDiagrambutton().setMenu(this.diagramMenuButton);
        CreationCommandRegistry commandRegistry = CreationCommandRegistry.getInstance((String)"org.eclipse.papyrus.infra.ui");
        for (CreationCommandDescriptor desc : commandRegistry.getCommandDescriptors()) {
            MenuItem menuItem = new MenuItem(this.diagramMenuButton, 8);
            menuItem.addSelectionListener((SelectionListener)new DiagramCreateListener(desc, null, (ICreationCommandRegistry)commandRegistry));
            menuItem.setText(desc.getLabel());
        }
        this.getNewDiagrambutton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorLookForEditorShell.this.diagramMenuButton.setVisible(true);
            }
        });
        this.getRemoveDiagrambutton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPageManager pageManager;
                IStructuredSelection iSelection = (IStructuredSelection)EditorLookForEditorShell.this.getModeFilteredTree().getViewer().getSelection();
                Iterator iterator = iSelection.iterator();
                try {
                    pageManager = (IPageManager)ServiceUtilsForEObject.getInstance().getService(IPageManager.class, (Object)EditorLookForEditorShell.this.model);
                }
                catch (ServiceException ex) {
                    Activator.log.error((Throwable)ex);
                    return;
                }
                LinkedList<EObject> pagesToDelete = new LinkedList<EObject>();
                while (iterator.hasNext()) {
                    EObject eObject = EMFHelper.getEObject(iterator.next());
                    if (!pageManager.allPages().contains(eObject)) continue;
                    pagesToDelete.add(eObject);
                }
                if (pagesToDelete.isEmpty()) {
                    return;
                }
                for (Object e2 : pagesToDelete) {
                    pageManager.closeAllOpenedPages(e2);
                }
                EditorLookForEditorShell.this.getModeFilteredTree().getViewer().refresh();
            }
        });
        IDoubleClickListener doubleClickHandler = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                EditorLookForEditorShell.this.okPressed();
            }
        };
        this.getModeFilteredTree().getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection = ((IStructuredSelection)EditorLookForEditorShell.this.getModeFilteredTree().getViewer().getSelection()).getFirstElement();
                EditorLookForEditorShell.this.refresh(selection);
            }
        });
        this.getModeFilteredTree().getViewer().addDoubleClickListener(doubleClickHandler);
        this.getDiagramfilteredTree().getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection = ((IStructuredSelection)EditorLookForEditorShell.this.getDiagramfilteredTree().getViewer().getSelection()).getFirstElement();
                EditorLookForEditorShell.this.refresh(selection);
            }
        });
        this.getDiagramfilteredTree().getViewer().addDoubleClickListener(doubleClickHandler);
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (EditorLookForEditorShell.this.adapterFactory instanceof IDisposable) {
                    ((IDisposable)EditorLookForEditorShell.this.adapterFactory).dispose();
                }
            }
        });
    }

    protected void okPressed() {
        if (this.treeViewer.getContentProvider() instanceof ICommitListener) {
            ((ICommitListener)this.treeViewer.getContentProvider()).commit(null);
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        this.setSelectedEditor(null);
        super.cancelPressed();
    }

    protected void refresh(Object selectedElement) {
        selectedElement = EMFHelper.getEObject((Object)selectedElement);
        Button but = this.getButton(0);
        if (this.isAValidEditor(selectedElement)) {
            but.setEnabled(true);
            this.selectedEditor = selectedElement;
        } else {
            but.setEnabled(false);
            this.selectedEditor = null;
        }
    }

    protected boolean isAValidEditor(Object object) {
        if (!(object instanceof EObject)) {
            return false;
        }
        EObject eObject = (EObject)object;
        try {
            return ((IPageManager)ServiceUtilsForEObject.getInstance().getService(IPageManager.class, (Object)eObject)).allPages().contains(object);
        }
        catch (ServiceException ex) {
            return false;
        }
    }

    public class DiagramCreateListener
    extends SelectionAdapter {
        private final CreationCommandDescriptor commandDescriptor;
        private EObject container;
        private final ICreationCommandRegistry iCreationCommandRegistry;

        public void widgetSelected(SelectionEvent e) {
            try {
                if (EditorLookForEditorShell.this.treeViewer.getSelection().isEmpty()) {
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)EditorLookForEditorShell.this.treeViewer.getSelection();
                EObject elt = EMFHelper.getEObject((Object)selection.getFirstElement());
                if (elt == null) {
                    return;
                }
                this.setContainer(elt);
                ModelSet modelSet = ServiceUtilsForEObject.getInstance().getModelSet((Object)elt);
                ICreationCommand creationCommand = this.iCreationCommandRegistry.getCommand(this.commandDescriptor.getCommandId());
                creationCommand.createDiagram(modelSet, this.container, null);
                EditorLookForEditorShell.this.getDiagramfilteredTree().getViewer().refresh();
                EditorLookForEditorShell.this.getModeFilteredTree().getViewer().refresh();
            }
            catch (NotFoundException ex) {
                Activator.log.error((Throwable)ex);
            }
            catch (ServiceException ex) {
                Activator.log.error((Throwable)ex);
            }
        }

        public DiagramCreateListener(CreationCommandDescriptor commandDescriptor, EObject container, ICreationCommandRegistry iCreationCommandRegistry) {
            this.commandDescriptor = commandDescriptor;
            this.container = container;
            this.iCreationCommandRegistry = iCreationCommandRegistry;
        }

        public void setContainer(EObject container) {
            this.container = container;
        }
    }
}

