/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.papyrus.infra.widgets.editors.MultipleStringEditor;
import org.eclipse.papyrus.infra.widgets.selectors.IntegerSelector;
import org.eclipse.swt.widgets.Composite;

public class MultipleIntegerEditor
extends MultipleStringEditor<IntegerSelector> {
    public MultipleIntegerEditor(Composite parent, int style) {
        super(parent, style, new IntegerSelector());
    }

    public MultipleIntegerEditor(Composite parent, int style, String label) {
        super(parent, style, new IntegerSelector(), label);
    }

    public MultipleIntegerEditor(Composite parent, int style, boolean ordered, boolean unique, String label) {
        super(parent, style, new IntegerSelector(), ordered, unique, label);
    }

    public MultipleIntegerEditor(Composite parent, boolean directCreation, boolean directCreationWithTreeViewer, int style) {
        super(parent, style, new IntegerSelector(), directCreation, directCreationWithTreeViewer);
    }

    @Override
    protected CellEditor createCellEditor(Object element) {
        return new IntegerCellEditor((Composite)this.tree);
    }

    @Override
    protected Object getDefaultValue() {
        return new Integer(0);
    }

    private static class IntegerCellEditor
    extends TextCellEditor {
        public IntegerCellEditor(Composite composite) {
            super(composite);
            this.setValidator(new ICellEditorValidator(){

                public String isValid(Object object) {
                    if (object instanceof Integer) {
                        return null;
                    }
                    String string = (String)object;
                    try {
                        Integer.parseInt(string);
                        return null;
                    }
                    catch (NumberFormatException exception) {
                        return exception.getMessage();
                    }
                }
            });
        }

        public Object doGetValue() {
            return Integer.parseInt((String)super.doGetValue());
        }

        public void doSetValue(Object value) {
            super.doSetValue((Object)value.toString());
        }
    }
}

