/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.rulers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.DefaultRangeModel;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Handle;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.internal.ui.rulers.GuideEditPart;
import org.eclipse.gef.internal.ui.rulers.RulerContextMenuProvider;
import org.eclipse.gef.internal.ui.rulers.RulerEditPart;
import org.eclipse.gef.internal.ui.rulers.RulerEditPartFactory;
import org.eclipse.gef.internal.ui.rulers.RulerRootEditPart;
import org.eclipse.gef.rulers.RulerProvider;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class RulerComposite
extends Composite {
    private EditDomain rulerEditDomain;
    private GraphicalViewer left;
    private GraphicalViewer top;
    private FigureCanvas editor;
    private GraphicalViewer diagramViewer;
    private Font font;
    private Listener layoutListener;
    private PropertyChangeListener propertyListener;
    private boolean layingOut = false;
    private boolean isRulerVisible = true;
    private boolean needToLayout = false;
    private Runnable runnable = new Runnable(){

        public void run() {
            RulerComposite.this.layout(false);
        }
    };
    static /* synthetic */ Class class$0;

    public RulerComposite(Composite parent, int style) {
        super(parent, style);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RulerComposite.this.disposeResources();
            }
        });
    }

    public static Rectangle calculateEditorTrim(Canvas canvas) {
        Rectangle bounds = canvas.getBounds();
        Rectangle clientArea = canvas.getClientArea();
        Rectangle result = new Rectangle(0, 0, bounds.width - clientArea.width, bounds.height - clientArea.height);
        if (result.width != 0 || result.height != 0) {
            Rectangle trim = canvas.computeTrim(0, 0, 0, 0);
            result.x = result.height == 0 ? 0 : trim.x;
            result.y = result.width == 0 ? 0 : trim.y;
        }
        return result;
    }

    public static Rectangle calculateRulerTrim(Canvas canvas) {
        if ("carbon".equals(SWT.getPlatform())) {
            Rectangle trim = canvas.computeTrim(0, 0, 0, 0);
            trim.width = 0 - trim.x * 2;
            trim.height = 0 - trim.y * 2;
            return trim;
        }
        return new Rectangle(0, 0, 0, 0);
    }

    private GraphicalViewer createRulerContainer(int orientation) {
        RulerViewer viewer = new RulerViewer();
        boolean isHorizontal = orientation == 1 || orientation == 4;
        viewer.setRootEditPart(new RulerRootEditPart(isHorizontal));
        viewer.setEditPartFactory(new RulerEditPartFactory(this.diagramViewer));
        viewer.createControl(this);
        ((GraphicalEditPart)((Object)viewer.getRootEditPart())).getFigure().setBorder((Border)new RulerBorder(isHorizontal));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.GraphicalViewer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        viewer.setProperty(clazz.toString(), this.diagramViewer);
        FigureCanvas canvas = (FigureCanvas)viewer.getControl();
        canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        if (this.font == null) {
            FontData[] data = canvas.getFont().getFontData();
            int i = 0;
            while (i < data.length) {
                data[i].setHeight(data[i].getHeight() - 1);
                ++i;
            }
            this.font = new Font((Device)Display.getCurrent(), data);
        }
        canvas.setFont(this.font);
        if (isHorizontal) {
            canvas.getViewport().setHorizontalRangeModel(this.editor.getViewport().getHorizontalRangeModel());
        } else {
            canvas.getViewport().setVerticalRangeModel(this.editor.getViewport().getVerticalRangeModel());
        }
        if (this.rulerEditDomain == null) {
            this.rulerEditDomain = new EditDomain();
            this.rulerEditDomain.setCommandStack(this.diagramViewer.getEditDomain().getCommandStack());
        }
        this.rulerEditDomain.addViewer(viewer);
        return viewer;
    }

    private void disposeResources() {
        if (this.diagramViewer != null) {
            this.diagramViewer.removePropertyChangeListener(this.propertyListener);
        }
        if (this.font != null) {
            this.font.dispose();
        }
    }

    private void disposeRulerViewer(GraphicalViewer viewer) {
        if (viewer == null) {
            return;
        }
        DefaultRangeModel rModel = new DefaultRangeModel();
        Viewport port = ((FigureCanvas)viewer.getControl()).getViewport();
        port.setHorizontalRangeModel((RangeModel)rModel);
        port.setVerticalRangeModel((RangeModel)rModel);
        this.rulerEditDomain.removeViewer(viewer);
        viewer.getControl().dispose();
    }

    public void doLayout() {
        if (this.left == null && this.top == null) {
            Rectangle area = this.getClientArea();
            if (this.editor != null && !this.editor.isDisposed() && !this.editor.getBounds().equals((Object)area)) {
                this.editor.setBounds(area);
            }
            return;
        }
        int leftWidth = 0;
        int topHeight = 0;
        Rectangle leftTrim = null;
        Rectangle topTrim = null;
        if (this.left != null) {
            leftTrim = RulerComposite.calculateRulerTrim((Canvas)this.left.getControl());
            leftWidth = this.left.getControl().computeSize((int)-1, (int)-1).x + leftTrim.width;
        }
        if (this.top != null) {
            topTrim = RulerComposite.calculateRulerTrim((Canvas)this.top.getControl());
            topHeight = this.top.getControl().computeSize((int)-1, (int)-1).y + topTrim.height;
        }
        Rectangle editorSize = this.getClientArea();
        editorSize.x = leftWidth;
        editorSize.y = topHeight;
        editorSize.width -= leftWidth;
        editorSize.height -= topHeight;
        this.editor.setBounds(editorSize);
        Rectangle trim = RulerComposite.calculateEditorTrim((Canvas)this.editor);
        if (this.left != null) {
            this.left.getControl().setBounds(0, topHeight - trim.x + leftTrim.x - 1, leftWidth, editorSize.height - trim.height + leftTrim.height + 1);
        }
        if (this.top != null) {
            this.top.getControl().setBounds(leftWidth - trim.y + topTrim.y - 1, 0, editorSize.width - trim.width + topTrim.width + 1, topHeight);
        }
    }

    private GraphicalViewer getRulerContainer(int orientation) {
        GraphicalViewer result = null;
        switch (orientation) {
            case 1: {
                result = this.top;
                break;
            }
            case 8: {
                result = this.left;
            }
        }
        return result;
    }

    public void layout(boolean change) {
        if (!this.layingOut && !this.isDisposed()) {
            this.checkWidget();
            if (change || this.needToLayout) {
                this.needToLayout = false;
                this.layingOut = true;
                this.doLayout();
                this.layingOut = false;
            }
        }
    }

    public void setGraphicalViewer(ScrollingGraphicalViewer primaryViewer) {
        Assert.isNotNull((Object)primaryViewer);
        Assert.isNotNull((Object)primaryViewer.getControl());
        Assert.isTrue((this.diagramViewer == null ? 1 : 0) != 0);
        this.diagramViewer = primaryViewer;
        this.editor = (FigureCanvas)this.diagramViewer.getControl();
        this.layoutListener = new Listener(){

            public void handleEvent(Event event) {
                RulerComposite.this.layout(true);
            }
        };
        this.addListener(11, this.layoutListener);
        this.editor.getHorizontalBar().addListener(22, this.layoutListener);
        this.editor.getHorizontalBar().addListener(23, this.layoutListener);
        this.editor.getVerticalBar().addListener(22, this.layoutListener);
        this.editor.getVerticalBar().addListener(23, this.layoutListener);
        this.propertyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String property = evt.getPropertyName();
                if ("horizontal ruler".equals(property)) {
                    RulerComposite.this.setRuler((RulerProvider)RulerComposite.this.diagramViewer.getProperty("horizontal ruler"), 1);
                } else if ("vertical ruler".equals(property)) {
                    RulerComposite.this.setRuler((RulerProvider)RulerComposite.this.diagramViewer.getProperty("vertical ruler"), 8);
                } else if ("ruler$visibility".equals(property)) {
                    RulerComposite.this.setRulerVisibility((Boolean)RulerComposite.this.diagramViewer.getProperty("ruler$visibility"));
                }
            }
        };
        this.diagramViewer.addPropertyChangeListener(this.propertyListener);
        Boolean rulerVisibility = (Boolean)this.diagramViewer.getProperty("ruler$visibility");
        if (rulerVisibility != null) {
            this.setRulerVisibility(rulerVisibility);
        }
        this.setRuler((RulerProvider)this.diagramViewer.getProperty("horizontal ruler"), 1);
        this.setRuler((RulerProvider)this.diagramViewer.getProperty("vertical ruler"), 8);
    }

    private void setRuler(RulerProvider provider, int orientation) {
        Object ruler = null;
        if (this.isRulerVisible && provider != null) {
            ruler = provider.getRuler();
        }
        if (ruler == null) {
            this.setRulerContainer(null, orientation);
            this.layout(true);
            return;
        }
        GraphicalViewer container = this.getRulerContainer(orientation);
        if (container == null) {
            container = this.createRulerContainer(orientation);
            this.setRulerContainer(container, orientation);
        }
        if (container.getContents() != ruler) {
            container.setContents(ruler);
            this.needToLayout = true;
            Display.getCurrent().asyncExec(this.runnable);
        }
    }

    private void setRulerContainer(GraphicalViewer container, int orientation) {
        if (orientation == 1) {
            if (this.top == container) {
                return;
            }
            this.disposeRulerViewer(this.top);
            this.top = container;
        } else if (orientation == 8) {
            if (this.left == container) {
                return;
            }
            this.disposeRulerViewer(this.left);
            this.left = container;
        }
    }

    private void setRulerVisibility(boolean isVisible) {
        if (this.isRulerVisible != isVisible) {
            this.isRulerVisible = isVisible;
            if (this.diagramViewer != null) {
                this.setRuler((RulerProvider)this.diagramViewer.getProperty("horizontal ruler"), 1);
                this.setRuler((RulerProvider)this.diagramViewer.getProperty("vertical ruler"), 8);
            }
        }
    }

    protected GraphicalViewer getLeft() {
        return this.left;
    }

    protected GraphicalViewer getTop() {
        return this.top;
    }

    protected FigureCanvas getEditor() {
        return this.editor;
    }

    private static class RulerBorder
    extends AbstractBorder {
        private static final Insets H_INSETS = new Insets(0, 1, 0, 0);
        private static final Insets V_INSETS = new Insets(1, 0, 0, 0);
        private boolean horizontal;

        public RulerBorder(boolean isHorizontal) {
            this.horizontal = isHorizontal;
        }

        public Insets getInsets(IFigure figure) {
            return this.horizontal ? H_INSETS : V_INSETS;
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            graphics.setForegroundColor(ColorConstants.buttonDarker);
            if (this.horizontal) {
                graphics.drawLine(figure.getBounds().getTopLeft(), figure.getBounds().getBottomLeft().translate(new Point(0, -4)));
            } else {
                graphics.drawLine(figure.getBounds().getTopLeft(), figure.getBounds().getTopRight().translate(new Point(-4, 0)));
            }
        }
    }

    private static class RulerViewer
    extends ScrollingGraphicalViewer {
        public RulerViewer() {
            this.init();
        }

        public void appendSelection(EditPart editpart) {
            if (editpart instanceof RootEditPart) {
                editpart = ((RootEditPart)editpart).getContents();
            }
            this.setFocus(editpart);
            super.appendSelection(editpart);
        }

        public Handle findHandleAt(Point p) {
            GraphicalEditPart gep = (GraphicalEditPart)this.findObjectAtExcluding(p, new ArrayList());
            if (gep == null || !(gep instanceof GuideEditPart)) {
                return null;
            }
            return new Handle(this, gep){
                final /* synthetic */ RulerViewer this$1;
                private final /* synthetic */ GraphicalEditPart val$gep;
                {
                    this.this$1 = rulerViewer;
                    this.val$gep = graphicalEditPart;
                }

                public DragTracker getDragTracker() {
                    return ((GuideEditPart)this.val$gep).getDragTracker(null);
                }

                public Point getAccessibleLocation() {
                    return null;
                }
            };
        }

        protected void init() {
            this.setContextMenu(new RulerContextMenuProvider(this));
            this.setKeyHandler(new RulerKeyHandler(this));
        }

        public void reveal(EditPart part) {
            if (part != this.getContents()) {
                super.reveal(part);
            }
        }

        protected void handleFocusGained(FocusEvent fe) {
            if (this.focusPart == null) {
                this.setFocus(this.getContents());
            }
            super.handleFocusGained(fe);
        }

        protected void handleFocusLost(FocusEvent fe) {
            super.handleFocusLost(fe);
            if (this.focusPart == this.getContents()) {
                this.setFocus(null);
            }
        }

        protected static class RulerKeyHandler
        extends GraphicalViewerKeyHandler {
            public RulerKeyHandler(GraphicalViewer viewer) {
                super(viewer);
            }

            public boolean keyPressed(KeyEvent event) {
                if (event.keyCode == 127) {
                    if (this.getFocusEditPart() instanceof GuideEditPart) {
                        RulerEditPart parent = (RulerEditPart)this.getFocusEditPart().getParent();
                        this.getViewer().getEditDomain().getCommandStack().execute(parent.getRulerProvider().getDeleteGuideCommand(this.getFocusEditPart().getModel()));
                        event.doit = false;
                        return true;
                    }
                    return false;
                }
                if ((event.stateMask & 0x10000) != 0 && event.keyCode == 0x1000001) {
                    EditPart parent = this.getFocusEditPart().getParent();
                    if (parent instanceof RulerEditPart) {
                        this.navigateTo(this.getFocusEditPart().getParent(), event);
                    }
                    return true;
                }
                return super.keyPressed(event);
            }
        }
    }
}

