/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.text;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.jdt.ui.IPackagesViewPart;
import org.eclipse.jface.text.IRegion;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.text.AbstractHyperlink;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class ResourceHyperlink
extends AbstractHyperlink {
    private IResource fResource;

    public ResourceHyperlink(IRegion region, String element, IResource res) {
        super(region, element);
        this.fResource = res;
    }

    public void open() {
        if (this.fResource == null) {
            return;
        }
        IResource resource = this.processAbsolutePathes();
        if (resource == null) {
            if (this.fElement.indexOf("$nl$/") == 0) {
                this.fElement = this.fElement.substring(5);
            }
            resource = this.fResource.getProject().findMember(this.fElement);
        }
        try {
            if (resource instanceof IFile) {
                IDE.openEditor((IWorkbenchPage)PDEPlugin.getActivePage(), (IFile)((IFile)resource), (boolean)true);
            } else if (resource != null) {
                IPackagesViewPart part = (IPackagesViewPart)PDEPlugin.getActivePage().showView("org.eclipse.jdt.ui.PackageExplorer");
                part.selectAndReveal((Object)resource);
            } else {
                Display.getDefault().beep();
            }
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
    }

    private IResource processAbsolutePathes() {
        if (!this.fElement.startsWith("/")) {
            return null;
        }
        String path = this.fElement.substring(1);
        int index = path.indexOf(47);
        String projectName = path.substring(0, index);
        if (index + 1 >= path.length()) {
            return null;
        }
        String fileName = path.substring(index + 1);
        IWorkspace workspace = this.fResource.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        if (project == null) {
            return null;
        }
        return project.findMember(fileName);
    }
}

