/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.workspace;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.ui.workspace.EclipseProjectConfigProvider;
import org.eclipse.xtext.ui.workspace.EclipseWorkspaceConfig;
import org.eclipse.xtext.util.UriUtil;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.ISourceFolder;
import org.eclipse.xtext.workspace.IWorkspaceConfig;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

@Data
public class EclipseProjectConfig
implements IProjectConfig {
    private final IProject project;
    private final EclipseProjectConfigProvider projectConfigProvider;

    public String getName() {
        return this.project.getName();
    }

    public URI getPath() {
        String _name = this.getName();
        String _plus = "/" + _name;
        String _plus_1 = String.valueOf(_plus) + "/";
        return URI.createPlatformResourceURI((String)_plus_1, (boolean)true);
    }

    public Set<? extends ISourceFolder> getSourceFolders() {
        return CollectionLiterals.emptySet();
    }

    public ISourceFolder findSourceFolderContaining(URI member) {
        Functions.Function1 _function = folder -> UriUtil.isPrefixOf((URI)folder.getPath(), (URI)member);
        return (ISourceFolder)IterableExtensions.findFirst(this.getSourceFolders(), (Functions.Function1)_function);
    }

    public IWorkspaceConfig getWorkspaceConfig() {
        IWorkspaceRoot _root = this.project.getWorkspace().getRoot();
        return new EclipseWorkspaceConfig(_root, this.projectConfigProvider);
    }

    public String toString() {
        return this.project.toString();
    }

    public EclipseProjectConfig(IProject project, EclipseProjectConfigProvider projectConfigProvider) {
        this.project = project;
        this.projectConfigProvider = projectConfigProvider;
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        return 31 * result + (this.projectConfigProvider == null ? 0 : this.projectConfigProvider.hashCode());
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EclipseProjectConfig other = (EclipseProjectConfig)obj;
        if (this.project == null ? other.project != null : !this.project.equals((Object)other.project)) {
            return false;
        }
        return !(this.projectConfigProvider == null ? other.projectConfigProvider != null : !this.projectConfigProvider.equals(other.projectConfigProvider));
    }

    @Pure
    public IProject getProject() {
        return this.project;
    }

    @Pure
    public EclipseProjectConfigProvider getProjectConfigProvider() {
        return this.projectConfigProvider;
    }
}

