/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.doubleClicking;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.xtext.ui.editor.model.CommonBreakIterator;
import org.eclipse.xtext.ui.editor.model.DocumentCharacterIterator;

public class AbstractWordAwareDoubleClickStrategy
extends DefaultTextDoubleClickStrategy {
    protected IRegion findWord(IDocument document, int offset) {
        int end;
        int start;
        block10: {
            IRegion line;
            block9: {
                try {
                    line = document.getLineInformationOfOffset(offset);
                    if (offset != line.getOffset() + line.getLength()) break block9;
                    return null;
                }
                catch (BadLocationException e) {
                    return null;
                }
            }
            CommonBreakIterator breakIter = this.createBreakIterator();
            DocumentCharacterIterator characterIterator = new DocumentCharacterIterator(document);
            breakIter.setText(characterIterator);
            start = breakIter.preceding(offset);
            if (start == -1) {
                start = line.getOffset();
            }
            if ((end = breakIter.following(offset)) == -1) {
                end = line.getOffset() + line.getLength();
            }
            if (breakIter.isBoundary(offset)) {
                if (end - offset > offset - start) {
                    start = offset;
                } else {
                    end = offset;
                }
            }
            if (end != start) break block10;
            return null;
        }
        return new Region(start, end - start);
    }

    protected CommonBreakIterator createBreakIterator() {
        return new CommonBreakIterator(false);
    }
}

