/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.animation;

import org.eclipse.xwt.XWTException;
import org.eclipse.xwt.animation.DoubleAnimationBase;
import org.eclipse.xwt.animation.Duration;
import org.eclipse.xwt.animation.FillBehavior;
import org.eclipse.xwt.animation.IEasingFunction;
import org.eclipse.xwt.animation.internal.ITimeline;
import org.eclipse.xwt.animation.internal.TridentTimeline;

public class DoubleAnimation
extends DoubleAnimationBase {
    private Double by;
    private Double from;
    private Double to;
    private IEasingFunction easingFunction;
    protected boolean additive = false;
    protected boolean cumulative = false;

    public DoubleAnimation() {
    }

    public DoubleAnimation(Double toValue, Duration duration) {
        this.setTo(toValue);
        this.setDuration(duration);
    }

    public DoubleAnimation(Double fromValue, Double toValue, Duration duration) {
        this.setTo(toValue);
        this.setFrom(fromValue);
        this.setDuration(duration);
    }

    public DoubleAnimation(Double toValue, Duration duration, FillBehavior fillBehavior) {
        this.setTo(toValue);
        this.setDuration(duration);
        this.setFillBehavior(fillBehavior);
    }

    public DoubleAnimation(Double fromValue, Double toValue, Duration duration, FillBehavior fillBehavior) {
        this.setTo(toValue);
        this.setFrom(fromValue);
        this.setDuration(duration);
        this.setFillBehavior(fillBehavior);
    }

    public IEasingFunction getEasingFunction() {
        return this.easingFunction;
    }

    public void setEasingFunction(IEasingFunction easingFunction) {
        this.easingFunction = easingFunction;
    }

    public Double getBy() {
        return this.by;
    }

    public void setBy(Double by) {
        this.by = by;
    }

    public Double getFrom() {
        return this.from;
    }

    public void setFrom(Double from) {
        this.from = from;
    }

    public Double getTo() {
        return this.to;
    }

    public void setTo(Double to) {
        this.to = to;
    }

    public boolean isAdditive() {
        return this.additive;
    }

    public void setAdditive(boolean additive) {
        this.additive = additive;
    }

    public boolean isCumulative() {
        return this.cumulative;
    }

    public void setCumulative(boolean cumulative) {
        this.cumulative = cumulative;
    }

    @Override
    protected void updateTimeline(ITimeline timeline, Object target) {
        super.updateTimeline(timeline, target);
        if (timeline instanceof TridentTimeline) {
            TridentTimeline tridentTimeline = (TridentTimeline)timeline;
            Double from = this.getFrom();
            Double to = this.getTo();
            if (from == null && to == null) {
                from = (Double)this.getCacheValue();
                to = (Double)this.getCurrentValue(target);
                if (from != null && from.equals(to)) {
                    throw new XWTException("action ignored");
                }
            }
            tridentTimeline.addPropertyToInterpolate(this.getTargetProperty(), from, to);
            tridentTimeline.setEasingFunction(this.getEasingFunction());
        }
    }
}

