/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.drafter.utils;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.uml.extensionpoints.Registry;
import org.eclipse.papyrus.uml.extensionpoints.library.IRegisteredLibrary;
import org.eclipse.papyrus.uml.profile.drafter.exceptions.NotFoundException;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Type;

public class UMLPrimitiveTypesModel {
    public Type UMLPrimitiveTypes_BOOLEAN;
    public Type UMLPrimitiveTypes_INTEGER;
    public Type UMLPrimitiveTypes_STRING;
    public Type UMLPrimitiveTypes_UNLIMITED_NATURAL;
    public Type UMLPrimitiveTypes_REAL;
    public static final String UMLPrimitiveTypes_BOOLEAN_NAME = "PrimitiveTypes::Boolean";
    public static final String UMLPrimitiveTypes_INTEGER_NAME = "PrimitiveTypes::Integer";
    public static final String UMLPrimitiveTypes_STRING_NAME = "PrimitiveTypes::String";
    public static final String UMLPrimitiveTypes_UNLIMITED_NATURAL_NAME = "PrimitiveTypes::UnlimitedNatural";
    public static final String UMLPrimitiveTypes_REAL_NAME = "PrimitiveTypes::Real";
    public static final String UMLPrimitiveTypes_LIBRARY_NAME = "UMLPrimitiveTypes";
    private static final Object UMLPrimitiveTypes_PACKAGE_NAME = "PrimitiveTypes";
    protected Resource libraryResource;
    private Package libraryPackage;

    public UMLPrimitiveTypesModel(ResourceSet resourceSet) {
        try {
            this.libraryResource = this.lookupPrimitiveTypesResource(resourceSet);
        }
        catch (NotFoundException e) {
            this.libraryResource = this.createPrimitiveTypesLibrary(resourceSet);
        }
        this.extractTypes();
    }

    private Resource createPrimitiveTypesLibrary(ResourceSet resourceSet) {
        throw new UnsupportedOperationException("UML Primitive type library creation not yet implemented");
    }

    private void extractTypes() {
        TreeIterator iter = this.libraryResource.getAllContents();
        while (iter.hasNext()) {
            Package p;
            EObject obj = (EObject)iter.next();
            if (obj instanceof Type) {
                Type type = (Type)obj;
                if (UMLPrimitiveTypes_BOOLEAN_NAME.equals(type.getQualifiedName())) {
                    this.UMLPrimitiveTypes_BOOLEAN = type;
                } else if (UMLPrimitiveTypes_INTEGER_NAME.equals(type.getQualifiedName())) {
                    this.UMLPrimitiveTypes_INTEGER = type;
                } else if (UMLPrimitiveTypes_REAL_NAME.equals(type.getQualifiedName())) {
                    this.UMLPrimitiveTypes_REAL = type;
                } else if (UMLPrimitiveTypes_STRING_NAME.equals(type.getQualifiedName())) {
                    this.UMLPrimitiveTypes_STRING = type;
                } else if (UMLPrimitiveTypes_UNLIMITED_NATURAL_NAME.equals(type.getQualifiedName())) {
                    this.UMLPrimitiveTypes_UNLIMITED_NATURAL = type;
                }
            }
            if (!(obj instanceof Package) || !UMLPrimitiveTypes_PACKAGE_NAME.equals((p = (Package)obj).getQualifiedName())) continue;
            this.libraryPackage = p;
        }
    }

    private Resource lookupPrimitiveTypesResource(ResourceSet resourceSet) throws NotFoundException {
        IRegisteredLibrary registeredLibrary = this.getIRegisteredLibrary(UMLPrimitiveTypes_LIBRARY_NAME);
        Resource resource = resourceSet.getResource(registeredLibrary.getUri(), true);
        return resource;
    }

    private IRegisteredLibrary getIRegisteredLibrary(String libraryName) throws NotFoundException {
        List registeredLibraries = Registry.getRegisteredLibraries();
        for (IRegisteredLibrary regLib : registeredLibraries) {
            if (!libraryName.equals(regLib.getName())) continue;
            return regLib;
        }
        throw new NotFoundException("No Library is registered under the name '" + libraryName + "'.");
    }

    public Resource getLibraryResource() {
        return this.libraryResource;
    }

    public Package getLibraryPackage() {
        return this.libraryPackage;
    }

    public List<Type> getTypes() {
        if (this.libraryPackage != null) {
            return this.libraryPackage.getOwnedTypes();
        }
        return Collections.emptyList();
    }

    public Type getDefaultType() {
        return this.UMLPrimitiveTypes_STRING;
    }
}

