/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.ide.undo.AbstractCopyOrMoveResourcesOperation;
import org.eclipse.ui.ide.undo.ResourceDescription;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

public class CopyResourcesOperation
extends AbstractCopyOrMoveResourcesOperation {
    IResource[] originalResources;
    ResourceDescription[] snapshotResourceDescriptions;

    public CopyResourcesOperation(IResource resource, IPath newPath, String label) {
        super(new IResource[]{resource}, new IPath[]{newPath}, label);
        this.setOriginalResources(new IResource[]{resource});
    }

    public CopyResourcesOperation(IResource[] resources, IPath destinationPath, String label) {
        super(resources, destinationPath, label);
        this.setOriginalResources(this.resources);
    }

    public CopyResourcesOperation(IResource[] resources, IPath[] destinationPaths, String label) {
        super(resources, destinationPaths, label);
        this.setOriginalResources(this.resources);
    }

    @Override
    protected void doExecute(IProgressMonitor monitor, IAdaptable uiInfo) throws CoreException {
        this.copy(monitor, uiInfo);
    }

    protected void copy(IProgressMonitor monitor, IAdaptable uiInfo) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.resources.length + (this.resourceDescriptions != null ? this.resourceDescriptions.length : 0)));
        subMonitor.setTaskName(UndoMessages.AbstractResourcesOperation_CopyingResourcesProgress);
        ArrayList<IResource> resourcesAtDestination = new ArrayList<IResource>();
        ArrayList<ResourceDescription> overwrittenResources = new ArrayList<ResourceDescription>();
        int i = 0;
        while (i < this.resources.length) {
            ResourceDescription[] overwrites;
            ResourceDescription[] resourceDescriptionArray = overwrites = WorkspaceUndoUtil.copy(new IResource[]{this.resources[i]}, this.getDestinationPath(this.resources[i], i), resourcesAtDestination, (IProgressMonitor)subMonitor.split(1), uiInfo, true, this.fCreateGroups, this.fCreateLinks, this.fRelativeToVariable);
            int n = overwrites.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceDescription overwrite = resourceDescriptionArray[n2];
                overwrittenResources.add(overwrite);
                ++n2;
            }
            ++i;
        }
        if (this.resourceDescriptions != null) {
            ResourceDescription[] resourceDescriptionArray = this.resourceDescriptions;
            int n = this.resourceDescriptions.length;
            int n3 = 0;
            while (n3 < n) {
                ResourceDescription resourceDescription = resourceDescriptionArray[n3];
                if (resourceDescription != null) {
                    resourceDescription.createResource((IProgressMonitor)subMonitor.split(1));
                }
                ++n3;
            }
        }
        this.setResourceDescriptions(overwrittenResources.toArray(new ResourceDescription[overwrittenResources.size()]));
        this.setTargetResources(resourcesAtDestination.toArray(new IResource[resourcesAtDestination.size()]));
    }

    @Override
    protected void doUndo(IProgressMonitor monitor, IAdaptable uiInfo) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        subMonitor.setTaskName(UndoMessages.AbstractResourcesOperation_CopyingResourcesProgress);
        WorkspaceUndoUtil.delete(this.resources, (IProgressMonitor)subMonitor.split(1), uiInfo, true);
        WorkspaceUndoUtil.recreate(this.resourceDescriptions, (IProgressMonitor)subMonitor.split(1), uiInfo);
        this.setResourceDescriptions(new ResourceDescription[0]);
        this.setTargetResources(this.originalResources);
        monitor.done();
    }

    @Override
    protected boolean updateResourceChangeDescriptionFactory(IResourceChangeDescriptionFactory factory, int operation) {
        boolean update = false;
        if (operation == UNDO) {
            Object[] objectArray = this.resources;
            int n = this.resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = objectArray[n2];
                update = true;
                factory.delete(resource);
                ++n2;
            }
            objectArray = this.resourceDescriptions;
            n = this.resourceDescriptions.length;
            n2 = 0;
            while (n2 < n) {
                IResource resourceDescription = objectArray[n2];
                if (resourceDescription != null) {
                    update = true;
                    IResource resource = resourceDescription.createResourceHandle();
                    factory.create(resource);
                }
                ++n2;
            }
        } else {
            int i = 0;
            while (i < this.resources.length) {
                update = true;
                IResource resource = this.resources[i];
                factory.copy(resource, this.getDestinationPath(resource, i));
                ++i;
            }
        }
        return update;
    }

    @Override
    public IStatus computeUndoableStatus(IProgressMonitor monitor) {
        IStatus status = super.computeUndoableStatus(monitor);
        if (!status.isOK()) {
            return status;
        }
        if (this.originalResources == null) {
            this.markInvalid();
            return this.getErrorStatus(UndoMessages.CopyResourcesOperation_NotAllowedDueToDataLoss);
        }
        ResourceDescription[] resourceDescriptionArray = this.snapshotResourceDescriptions;
        int n = this.snapshotResourceDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceDescription snapshotResourceDescription = resourceDescriptionArray[n2];
            if (!snapshotResourceDescription.verifyExistence(true)) {
                this.markInvalid();
                return this.getErrorStatus(UndoMessages.CopyResourcesOperation_NotAllowedDueToDataLoss);
            }
            ++n2;
        }
        if (status.isOK()) {
            status = this.computeDeleteStatus();
        }
        if (status.isOK() && this.resourceDescriptions != null && this.resourceDescriptions.length > 0) {
            status = this.computeCreateStatus(true);
        }
        return status;
    }

    private void setOriginalResources(IResource[] originals) {
        this.originalResources = originals;
        this.snapshotResourceDescriptions = new ResourceDescription[originals.length];
        int i = 0;
        while (i < originals.length) {
            this.snapshotResourceDescriptions[i] = ResourceDescription.fromResource(originals[i]);
            ++i;
        }
    }
}

