/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelrepair.internal.uripattern;

import java.text.MessageFormat;
import java.util.regex.Pattern;
import org.eclipse.papyrus.uml.modelrepair.internal.uripattern.ProfileNamespaceURIPatternComparison;
import org.eclipse.papyrus.uml.modelrepair.internal.uripattern.ProfileNamespaceURIPatternMatchResult;

public class ProfileNamespaceURIPattern {
    private final Pattern pattern;
    private final MessageFormat versionFormat;

    public ProfileNamespaceURIPattern(String pattern) {
        this(pattern, null);
    }

    public ProfileNamespaceURIPattern(String pattern, String versionFormat) {
        this.pattern = Pattern.compile(pattern);
        this.versionFormat = versionFormat != null ? new MessageFormat(versionFormat) : null;
    }

    public Pattern getRegexPattern() {
        return this.pattern;
    }

    public MessageFormat getVersionFormat() {
        return this.versionFormat;
    }

    public ProfileNamespaceURIPatternComparison compare(String lhsUri, String rhsUri) {
        ProfileNamespaceURIPatternMatchResult rhsPattern;
        ProfileNamespaceURIPatternMatchResult lhsPattern = this.match(lhsUri);
        if (lhsPattern.hasMatched() && (rhsPattern = this.match(rhsUri)).hasMatched()) {
            return new ProfileNamespaceURIPatternComparison(lhsPattern, rhsPattern);
        }
        return ProfileNamespaceURIPatternComparison.INVALID;
    }

    public ProfileNamespaceURIPatternMatchResult match(String uri) {
        if (uri == null) {
            return ProfileNamespaceURIPatternMatchResult.NO_MATCH;
        }
        return new ProfileNamespaceURIPatternMatchResult(this.pattern.matcher(uri), this.versionFormat);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pattern == null ? 0 : this.pattern.pattern().hashCode());
        result = 31 * result + (this.versionFormat == null ? 0 : this.versionFormat.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProfileNamespaceURIPattern other = (ProfileNamespaceURIPattern)obj;
        if (this.pattern == null ? other.pattern != null : !this.pattern.pattern().equals(other.pattern.pattern())) {
            return false;
        }
        return !(this.versionFormat == null ? other.versionFormat != null : !this.versionFormat.equals(other.versionFormat));
    }
}

