/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.matrix.painters;

import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.CheckBoxPainter;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.papyrus.uml.nattable.matrix.configs.CellMatrixRelationshipEnum;
import org.eclipse.papyrus.uml.nattable.matrix.configs.MatrixRelationshipDisplayConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class MatrixRelationshipCellBoxPainter
extends CheckBoxPainter {
    private final Image checkedImg;
    private final Image uncheckedImg;
    private final Image checkedDisableImg;

    public MatrixRelationshipCellBoxPainter() {
        this(true);
    }

    public MatrixRelationshipCellBoxPainter(boolean paintBg) {
        this(GUIHelper.getImage((String)"checked"), GUIHelper.getImage((String)"unchecked"), GUIHelper.getImage((String)"checked_disabled"), paintBg);
    }

    public MatrixRelationshipCellBoxPainter(Image checkedImg, Image uncheckedImg, Image checkedDisableImg) {
        this(checkedImg, uncheckedImg, checkedDisableImg, true);
    }

    public MatrixRelationshipCellBoxPainter(Image checkedImg, Image uncheckedImg, Image checkedDisableImg, boolean paintBg) {
        super(paintBg);
        this.checkedImg = checkedImg;
        this.uncheckedImg = uncheckedImg;
        this.checkedDisableImg = checkedDisableImg;
    }

    protected Image getImage(ILayerCell cell, IConfigRegistry configRegistry) {
        CellMatrixRelationshipEnum convertedValue = this.localConvertDataType(cell, configRegistry);
        Image returnedImage = null;
        switch (convertedValue) {
            case UNCHECKED: {
                returnedImage = this.uncheckedImg;
                break;
            }
            case CHECKED: {
                returnedImage = this.checkedImg;
                break;
            }
            case CHECKED_MORE_THAN_2_ENDS: 
            case CHECKED_MORE_THAN_ONE_LINK: {
                returnedImage = this.checkedDisableImg;
                break;
            }
        }
        return returnedImage;
    }

    protected CellMatrixRelationshipEnum localConvertDataType(ILayerCell cell, IConfigRegistry configRegistry) {
        IDisplayConverter displayConverter = (IDisplayConverter)configRegistry.getConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, cell.getDisplayMode(), cell.getConfigLabels().getLabels());
        CellMatrixRelationshipEnum convertedValue = null;
        if (displayConverter instanceof MatrixRelationshipDisplayConverter) {
            convertedValue = (CellMatrixRelationshipEnum)((Object)displayConverter.canonicalToDisplayValue(cell, configRegistry, cell.getDataValue()));
        }
        if (convertedValue == null) {
            convertedValue = CellMatrixRelationshipEnum.UNKNOWN_VALUE;
        }
        return convertedValue;
    }

    protected String getAdditionalText(ILayerCell cell, IConfigRegistry configRegistry) {
        CellMatrixRelationshipEnum convertedValue = this.localConvertDataType(cell, configRegistry);
        String txt = "";
        switch (convertedValue) {
            case CHECKED_MORE_THAN_2_ENDS: 
            case CHECKED_MORE_THAN_ONE_LINK: {
                txt = convertedValue.toString();
                break;
            }
        }
        return txt;
    }

    public void paintCell(ILayerCell cell, GC gc, Rectangle bounds, IConfigRegistry configRegistry) {
        super.paintCell(cell, gc, bounds, configRegistry);
        String txt = this.getAdditionalText(cell, configRegistry);
        if (!txt.isEmpty()) {
            IStyle cellStyle = CellStyleUtil.getCellStyle((ILayerCell)cell, (IConfigRegistry)configRegistry);
            Image image = this.getImage(cell, configRegistry);
            Rectangle imageBounds = image.getBounds();
            Color previousForeground = gc.getForeground();
            gc.setForeground(GUIHelper.COLOR_BLACK);
            gc.drawText(txt, bounds.x + CellStyleUtil.getHorizontalAlignmentPadding((IStyle)cellStyle, (Rectangle)bounds, (int)imageBounds.width) + imageBounds.width, bounds.y + CellStyleUtil.getVerticalAlignmentPadding((IStyle)cellStyle, (Rectangle)bounds, (int)imageBounds.height), true);
            gc.setForeground(previousForeground);
        }
    }
}

