/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.internal.handler;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Objects;
import org.eclipse.core.commands.State;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.resource.ShardResourceHelper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeManager;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SubmodelState
extends State
implements ISelectionListener {
    private ISelectionService selectionService = null;
    private Reference<EObject> selectedElement;

    public SubmodelState() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            this.selectionService = window.getSelectionService();
            if (this.selectionService != null) {
                this.selectionService.addSelectionListener((ISelectionListener)this);
                this.update(this.selectionService.getSelection());
            }
        }
    }

    public void dispose() {
        if (this.selectionService != null) {
            this.selectionService.removeSelectionListener((ISelectionListener)this);
        }
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.update(selection);
    }

    private void update(ISelection selection) {
        EObject element;
        boolean state = false;
        this.selectedElement = null;
        if (selection instanceof IStructuredSelection && (element = (EObject)((IStructuredSelection)selection).toList().stream().map(EMFHelper::getEObject).filter(Objects::nonNull).findFirst().orElse(null)) != null) {
            this.selectedElement = new WeakReference<EObject>(element);
            state = ControlModeManager.getInstance().canCreateSubmodel(element);
        }
        this.setValue(state);
    }

    public Object getValue() {
        EObject element;
        boolean result = false;
        EObject eObject = element = this.selectedElement == null ? null : this.selectedElement.get();
        if (element != null) {
            result = SubmodelState.isIndependentSubmodel(element);
        }
        return result;
    }

    static boolean isIndependentSubmodel(EObject object) {
        boolean result = false;
        Throwable throwable = null;
        Object var3_4 = null;
        try (ShardResourceHelper helper = new ShardResourceHelper(object);){
            result = !helper.isShard();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }
}

