/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.infra.services.controlmode.messages.Messages;
import org.eclipse.papyrus.infra.services.controlmode.ui.OptionalMessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AskUserCommand
extends AbstractTransactionalCommand {
    private static final String CANCEL_BUTTON_LABEL = Messages.getString("AskUserCommand.button.cancel");
    private static final String OK_BUTTON_LABEL = Messages.getString("AskUserCommand.button.ok");
    private static final String COMMAND_TITLE = Messages.getString("AskUserCommand.user.command.title");
    private static final String COMMAND_VALIDATION_TITLE = Messages.getString("AskUserCommand.user.command.validation.title");
    private String message;
    private String title;
    private boolean optional;
    private String id;

    public AskUserCommand(TransactionalEditingDomain domain, String message, String title) {
        super(domain, COMMAND_TITLE, null);
        this.message = message;
        this.title = title;
    }

    public AskUserCommand(TransactionalEditingDomain domain, String message, String title, boolean optional, String id) {
        super(domain, COMMAND_VALIDATION_TITLE, null);
        this.message = message;
        this.title = title;
        this.optional = optional;
        this.id = id;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        int returnButton;
        boolean confirm = false;
        confirm = this.optional ? (returnButton = OptionalMessageDialog.open(this.id, Display.getDefault().getActiveShell(), this.title, null, this.message, 4, new String[]{OK_BUTTON_LABEL, CANCEL_BUTTON_LABEL}, 0)) == 0 || 1025 == returnButton : MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)this.title, (String)this.message);
        if (confirm) {
            return CommandResult.newOKCommandResult();
        }
        return CommandResult.newCancelledCommandResult();
    }
}

