/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.papyrus.infra.core.resource.IRollbackStatus;

public class RollbackStatus
extends Status
implements IRollbackStatus {
    private final Set<?> causalObjects;

    public RollbackStatus(String pluginId, int reason, String message) {
        this(pluginId, reason, message, null, null);
    }

    public RollbackStatus(String pluginId, int reason, String message, Throwable exception) {
        this(pluginId, reason, message, null, exception);
    }

    public RollbackStatus(String pluginId, int reason, String message, Iterable<?> causalObjects) {
        this(pluginId, reason, message, causalObjects, null);
    }

    public RollbackStatus(String pluginId, int reason, String message, Iterable<?> causalObjects, Throwable exception) {
        super(4, pluginId, reason, message, exception);
        this.causalObjects = causalObjects == null ? Collections.emptySet() : ImmutableSet.copyOf(causalObjects);
    }

    @Override
    public Collection<?> getCausalObjects() {
        return this.causalObjects;
    }

    public static IRollbackStatus findRollbackStatus(IStatus status) {
        IRollbackStatus result = null;
        if (status != null) {
            if (status instanceof IRollbackStatus) {
                result = (IRollbackStatus)status;
            } else if (status.isMultiStatus()) {
                IStatus[] children = status.getChildren();
                int i = 0;
                while (result == null && i < children.length) {
                    result = RollbackStatus.findRollbackStatus(children[i]);
                    ++i;
                }
            }
            if (result == null && status.getException() instanceof RollbackException) {
                result = RollbackStatus.findRollbackStatus(((RollbackException)status.getException()).getStatus());
            }
        }
        return result;
    }

    public static class Multi
    extends MultiStatus
    implements IRollbackStatus {
        private IRollbackStatus rollback;

        public Multi(String pluginId, int code, IStatus[] newChildren, String message, Throwable exception) {
            super(pluginId, code, newChildren, message, exception);
        }

        public Multi(String pluginId, int code, String message, Throwable exception) {
            super(pluginId, code, message, exception);
        }

        IRollbackStatus getRollback() {
            if (this.rollback == null) {
                this.rollback = RollbackStatus.findRollbackStatus(this);
            }
            return this.rollback;
        }

        @Override
        public Collection<?> getCausalObjects() {
            IRollbackStatus rollback = this.getRollback();
            return rollback == null ? Collections.emptySet() : rollback.getCausalObjects();
        }
    }
}

