/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.internal.language;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.internal.language.DefaultLanguageProvider;
import org.eclipse.papyrus.infra.core.language.ILanguage;
import org.eclipse.papyrus.infra.core.language.ILanguageProvider;
import org.eclipse.papyrus.infra.core.language.ILanguageService;
import org.eclipse.papyrus.infra.core.language.Language;
import org.eclipse.papyrus.infra.core.language.Version;
import org.eclipse.papyrus.infra.core.resource.ModelSet;

public class LanguageProviderRegistry
implements ILanguageProvider.Registry {
    private static final String EXT_POINT = "language";
    private static final ILanguageProvider NULL_PROVIDER = new ILanguageProvider(){

        @Override
        public Iterable<ILanguage> getLanguages(ILanguageService languageService, URI modelURI, boolean uriHasFileExtension) {
            return Collections.emptyList();
        }
    };
    private final List<ILanguageProvider> providers = Lists.newArrayListWithExpectedSize((int)2);
    private boolean needPrune;

    public LanguageProviderRegistry() {
        new MyRegistryReader().readRegistry();
    }

    private void prune() {
        if (this.needPrune) {
            this.needPrune = false;
            ListIterator<ILanguageProvider> iter = this.providers.listIterator();
            while (iter.hasNext()) {
                MyRegistryReader.Descriptor desc;
                ILanguageProvider next = iter.next();
                if (next == NULL_PROVIDER) {
                    iter.remove();
                    continue;
                }
                if (!(next instanceof MyRegistryReader.Descriptor) || (desc = (MyRegistryReader.Descriptor)next).instance == null) continue;
                iter.set(desc.instance);
            }
        }
    }

    @Override
    public Collection<ILanguageProvider> getProviders() {
        this.prune();
        return Collections.unmodifiableCollection(this.providers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProvider(String className) {
        List<ILanguageProvider> list = this.providers;
        synchronized (list) {
            Iterator<ILanguageProvider> iter = this.providers.iterator();
            while (iter.hasNext()) {
                ILanguageProvider next = iter.next();
                if (next instanceof MyRegistryReader.Descriptor) {
                    MyRegistryReader.Descriptor desc = (MyRegistryReader.Descriptor)next;
                    if (!className.equals(desc.getClassName())) continue;
                    iter.remove();
                    break;
                }
                if (!className.equals(next.getClass().getName())) continue;
                iter.remove();
                break;
            }
        }
    }

    private class MyRegistryReader
    extends RegistryReader {
        private static final String A_CLASS = "class";
        private static final String E_PROVIDER = "provider";
        private static final String E_CONTENT_TYPE = "content-type";
        private static final String E_LANGUAGE = "language";
        private static final String A_ID = "id";
        private static final String A_VERSION = "version";
        private static final String A_NAME = "name";
        private Descriptor currentDescriptor;

        MyRegistryReader() {
            super(Platform.getExtensionRegistry(), "org.eclipse.papyrus.infra.core", "language");
        }

        protected boolean readElement(IConfigurationElement element, boolean add) {
            return add ? this.handleAdd(element) : this.handleRemove(element);
        }

        private boolean handleAdd(IConfigurationElement element) {
            boolean result = true;
            if (E_PROVIDER.equals(element.getName())) {
                this.currentDescriptor = new Descriptor(element, A_CLASS);
                LanguageProviderRegistry.this.providers.add(this.currentDescriptor);
            }
            return result;
        }

        private boolean handleRemove(IConfigurationElement element) {
            String className;
            boolean result = true;
            if (E_PROVIDER.equals(element.getName()) && (className = this.getClassName(element, A_CLASS)) != null) {
                LanguageProviderRegistry.this.removeProvider(className);
            }
            return result;
        }

        String getClassName(IConfigurationElement provider, String attributeName) {
            IConfigurationElement[] classes;
            String result = provider.getAttribute(attributeName);
            if (result == null && (classes = provider.getChildren(attributeName)).length > 0) {
                result = classes[0].getAttribute(A_CLASS);
            }
            return result;
        }

        private class Descriptor
        extends RegistryReader.PluginClassDescriptor
        implements ILanguageProvider {
            private ILanguageProvider instance;

            Descriptor(IConfigurationElement element, String attributeName) {
                super(element, attributeName);
            }

            String getClassName() {
                return MyRegistryReader.this.getClassName(this.element, this.attributeName);
            }

            ILanguageProvider getInstance() {
                if (this.instance == null) {
                    try {
                        String className = this.getClassName();
                        this.instance = className == null ? this.createDefaultProvider() : (ILanguageProvider)this.createInstance();
                    }
                    catch (Exception e) {
                        Activator.log.error("Failed to instantiate language provider extension.", (Throwable)e);
                        this.instance = NULL_PROVIDER;
                    }
                    LanguageProviderRegistry.this.needPrune = true;
                }
                return this.instance;
            }

            @Override
            public Iterable<ILanguage> getLanguages(ILanguageService languageService, URI modelURI, boolean uriHasFileExtension) {
                return this.getInstance().getLanguages(languageService, modelURI, uriHasFileExtension);
            }

            @Override
            public Iterable<ILanguage> getLanguages(ILanguageService languageService, ModelSet modelSet) {
                return this.getInstance().getLanguages(languageService, modelSet);
            }

            ILanguageProvider createDefaultProvider() throws CoreException {
                DefaultLanguageProvider result = new DefaultLanguageProvider();
                IConfigurationElement[] iConfigurationElementArray = this.element.getChildren();
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement next = iConfigurationElementArray[n2];
                    if (MyRegistryReader.E_CONTENT_TYPE.equals(next.getName())) {
                        this.addContentType(result, next);
                    } else if ("language".equals(next.getName())) {
                        this.addLanguage(result, next);
                    }
                    ++n2;
                }
                return result;
            }

            private void addContentType(DefaultLanguageProvider provider, IConfigurationElement contentType) {
                String id = contentType.getAttribute(MyRegistryReader.A_ID);
                if (Strings.isNullOrEmpty((String)id)) {
                    MyRegistryReader.this.logMissingAttribute(contentType, MyRegistryReader.A_ID);
                } else {
                    provider.addContentType(id);
                }
            }

            private void addLanguage(DefaultLanguageProvider provider, IConfigurationElement language) throws CoreException {
                String className = language.getAttribute(MyRegistryReader.A_CLASS);
                if (Strings.isNullOrEmpty((String)className)) {
                    className = Language.class.getName();
                }
                if (!className.equals(Language.class.getName())) {
                    provider.addLanguage(language, MyRegistryReader.A_CLASS);
                } else {
                    String name;
                    String version;
                    String id = language.getAttribute(MyRegistryReader.A_ID);
                    if (Strings.isNullOrEmpty((String)id)) {
                        MyRegistryReader.this.logMissingAttribute(language, MyRegistryReader.A_ID);
                    }
                    if (Strings.isNullOrEmpty((String)(version = language.getAttribute(MyRegistryReader.A_VERSION)))) {
                        MyRegistryReader.this.logMissingAttribute(language, MyRegistryReader.A_VERSION);
                    }
                    if (Strings.isNullOrEmpty((String)(name = language.getAttribute(MyRegistryReader.A_NAME)))) {
                        MyRegistryReader.this.logMissingAttribute(language, MyRegistryReader.A_NAME);
                    }
                    provider.addLanguage(new Language(id, new Version(version), name));
                }
            }
        }
    }
}

