/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.CmapFormat;

public class CmapFormat4
extends CmapFormat {
    public int language;
    private int segCountX2;
    private int searchRange;
    private int entrySelector;
    private int rangeShift;
    private int[] endCode;
    private int[] startCode;
    private int[] idDelta;
    private int[] idRangeOffset;
    private int[] glyphIdArray;
    private int segCount;
    private int first;
    private int last;

    protected CmapFormat4(RandomAccessFile randomAccessFile) throws IOException {
        super(randomAccessFile);
        this.format = 4;
        this.segCountX2 = randomAccessFile.readUnsignedShort();
        this.segCount = this.segCountX2 / 2;
        this.endCode = new int[this.segCount];
        this.startCode = new int[this.segCount];
        this.idDelta = new int[this.segCount];
        this.idRangeOffset = new int[this.segCount];
        this.searchRange = randomAccessFile.readUnsignedShort();
        this.entrySelector = randomAccessFile.readUnsignedShort();
        this.rangeShift = randomAccessFile.readUnsignedShort();
        this.last = -1;
        int n = 0;
        while (n < this.segCount) {
            this.endCode[n] = randomAccessFile.readUnsignedShort();
            if (this.endCode[n] > this.last) {
                this.last = this.endCode[n];
            }
            ++n;
        }
        randomAccessFile.readUnsignedShort();
        int n2 = 0;
        while (n2 < this.segCount) {
            this.startCode[n2] = randomAccessFile.readUnsignedShort();
            if (n2 == 0 || this.startCode[n2] < this.first) {
                this.first = this.startCode[n2];
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.segCount) {
            this.idDelta[n3] = randomAccessFile.readUnsignedShort();
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.segCount) {
            this.idRangeOffset[n4] = randomAccessFile.readUnsignedShort();
            ++n4;
        }
        int n5 = (this.length - 16 - this.segCount * 8) / 2;
        this.glyphIdArray = new int[n5];
        int n6 = 0;
        while (n6 < n5) {
            this.glyphIdArray[n6] = randomAccessFile.readUnsignedShort();
            ++n6;
        }
    }

    public int getFirst() {
        return this.first;
    }

    public int getLast() {
        return this.last;
    }

    public int mapCharCode(int n) {
        try {
            if (n < 0 || n >= 65534) {
                return 0;
            }
            int n2 = 0;
            while (n2 < this.segCount) {
                if (this.endCode[n2] >= n) {
                    if (this.startCode[n2] <= n) {
                        if (this.idRangeOffset[n2] > 0) {
                            return this.glyphIdArray[this.idRangeOffset[n2] / 2 + (n - this.startCode[n2]) - (this.segCount - n2)];
                        }
                        return (this.idDelta[n2] + n) % 65536;
                    }
                    break;
                }
                ++n2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("error: Array out of bounds - " + arrayIndexOutOfBoundsException.getMessage());
        }
        return 0;
    }

    public String toString() {
        return super.toString() + ", segCountX2: " + this.segCountX2 + ", searchRange: " + this.searchRange + ", entrySelector: " + this.entrySelector + ", rangeShift: " + this.rangeShift + ", endCode: " + this.endCode + ", startCode: " + this.endCode + ", idDelta: " + this.idDelta + ", idRangeOffset: " + this.idRangeOffset;
    }
}

