/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.build;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.build.ClusteringStorageAwareResourceLoader;
import org.eclipse.xtext.build.IndexState;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.clustering.IResourceClusteringPolicy;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

@FinalFieldsConstructor
public class BuildContext {
    private final Functions.Function1<? super URI, ? extends IResourceServiceProvider> resourceServiceProviderProvider;
    @Accessors
    private final XtextResourceSet resourceSet;
    @Accessors
    private final IndexState oldState;
    @Accessors
    private final IResourceClusteringPolicy clusteringPolicy;
    @Accessors
    private final CancelIndicator cancelIndicator;
    private ClusteringStorageAwareResourceLoader loader;

    public <T> Iterable<T> executeClustered(Iterable<URI> uri, Functions.Function1<? super Resource, ? extends T> operation) {
        if (this.loader == null) {
            ClusteringStorageAwareResourceLoader _clusteringStorageAwareResourceLoader;
            this.loader = _clusteringStorageAwareResourceLoader = new ClusteringStorageAwareResourceLoader(this);
        }
        Functions.Function1 _function = it -> this.canHandle((URI)it);
        return this.loader.executeClustered(IterableExtensions.filter(uri, (Functions.Function1)_function), operation);
    }

    protected boolean canHandle(URI uri) {
        IResourceServiceProvider resourceServiceProvider = (IResourceServiceProvider)this.resourceServiceProviderProvider.apply((Object)uri);
        if (resourceServiceProvider == null) {
            return false;
        }
        return resourceServiceProvider.canHandle(uri);
    }

    public IResourceServiceProvider getResourceServiceProvider(URI uri) {
        IResourceServiceProvider resourceServiceProvider = (IResourceServiceProvider)this.resourceServiceProviderProvider.apply((Object)uri);
        return resourceServiceProvider;
    }

    public BuildContext(Functions.Function1<? super URI, ? extends IResourceServiceProvider> resourceServiceProviderProvider, XtextResourceSet resourceSet, IndexState oldState, IResourceClusteringPolicy clusteringPolicy, CancelIndicator cancelIndicator) {
        this.resourceServiceProviderProvider = resourceServiceProviderProvider;
        this.resourceSet = resourceSet;
        this.oldState = oldState;
        this.clusteringPolicy = clusteringPolicy;
        this.cancelIndicator = cancelIndicator;
    }

    @Pure
    public XtextResourceSet getResourceSet() {
        return this.resourceSet;
    }

    @Pure
    public IndexState getOldState() {
        return this.oldState;
    }

    @Pure
    public IResourceClusteringPolicy getClusteringPolicy() {
        return this.clusteringPolicy;
    }

    @Pure
    public CancelIndicator getCancelIndicator() {
        return this.cancelIndicator;
    }
}

